@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingGroupIndexingConfiguration
import com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingIndexingConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingGroupIndexingConfiguration.Companion.toKotlin as indexingConfigurationThingGroupIndexingConfigurationToKotlin
import com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingIndexingConfiguration.Companion.toKotlin as indexingConfigurationThingIndexingConfigurationToKotlin

/**
 * Builder for [IndexingConfiguration].
 */
@PulumiTagMarker
public class IndexingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IndexingConfigurationArgs = IndexingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IndexingConfigurationArgsBuilder.() -> Unit) {
        val builder = IndexingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IndexingConfiguration {
        val builtJavaResource = com.pulumi.aws.iot.IndexingConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IndexingConfiguration(builtJavaResource)
    }
}

/**
 * Managing [IoT Thing indexing](https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.IndexingConfiguration;
 * import com.pulumi.aws.iot.IndexingConfigurationArgs;
 * import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationArgs;
 * import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndexingConfiguration("example", IndexingConfigurationArgs.builder()
 *             .thingIndexingConfiguration(IndexingConfigurationThingIndexingConfigurationArgs.builder()
 *                 .customFields(
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("shadow.desired.power")
 *                         .type("Boolean")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("attributes.version")
 *                         .type("Number")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("shadow.name.thing1shadow.desired.DefaultDesired")
 *                         .type("String")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number")
 *                         .type("Number")
 *                         .build())
 *                 .deviceDefenderIndexingMode("VIOLATIONS")
 *                 .filter(IndexingConfigurationThingIndexingConfigurationFilterArgs.builder()
 *                     .namedShadowNames("thing1shadow")
 *                     .build())
 *                 .namedShadowIndexingMode("ON")
 *                 .thingConnectivityIndexingMode("STATUS")
 *                 .thingIndexingMode("REGISTRY_AND_SHADOW")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 */
public class IndexingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.iot.IndexingConfiguration,
) : KotlinCustomResource(javaResource, IndexingConfigurationMapper) {
    /**
     * Thing group indexing configuration. See below.
     */
    public val thingGroupIndexingConfiguration:
        Output<IndexingConfigurationThingGroupIndexingConfiguration>
        get() = javaResource.thingGroupIndexingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                indexingConfigurationThingGroupIndexingConfigurationToKotlin(args0)
            })
        })

    /**
     * Thing indexing configuration. See below.
     */
    public val thingIndexingConfiguration: Output<IndexingConfigurationThingIndexingConfiguration>
        get() = javaResource.thingIndexingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                indexingConfigurationThingIndexingConfigurationToKotlin(args0)
            })
        })
}

public object IndexingConfigurationMapper : ResourceMapper<IndexingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.IndexingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): IndexingConfiguration =
        IndexingConfiguration(javaResource as com.pulumi.aws.iot.IndexingConfiguration)
}

/**
 * @see [IndexingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IndexingConfiguration].
 */
public suspend fun indexingConfiguration(
    name: String,
    block: suspend IndexingConfigurationResourceBuilder.() -> Unit,
): IndexingConfiguration {
    val builder = IndexingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IndexingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun indexingConfiguration(name: String): IndexingConfiguration {
    val builder = IndexingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
