@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.IndexingConfigurationArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.IndexingConfigurationThingGroupIndexingConfigurationArgs
import com.pulumi.aws.iot.kotlin.inputs.IndexingConfigurationThingGroupIndexingConfigurationArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.IndexingConfigurationThingIndexingConfigurationArgs
import com.pulumi.aws.iot.kotlin.inputs.IndexingConfigurationThingIndexingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Managing [IoT Thing indexing](https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.IndexingConfiguration;
 * import com.pulumi.aws.iot.IndexingConfigurationArgs;
 * import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationArgs;
 * import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndexingConfiguration("example", IndexingConfigurationArgs.builder()
 *             .thingIndexingConfiguration(IndexingConfigurationThingIndexingConfigurationArgs.builder()
 *                 .customFields(
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("shadow.desired.power")
 *                         .type("Boolean")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("attributes.version")
 *                         .type("Number")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("shadow.name.thing1shadow.desired.DefaultDesired")
 *                         .type("String")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number")
 *                         .type("Number")
 *                         .build())
 *                 .deviceDefenderIndexingMode("VIOLATIONS")
 *                 .filter(IndexingConfigurationThingIndexingConfigurationFilterArgs.builder()
 *                     .namedShadowNames("thing1shadow")
 *                     .build())
 *                 .namedShadowIndexingMode("ON")
 *                 .thingConnectivityIndexingMode("STATUS")
 *                 .thingIndexingMode("REGISTRY_AND_SHADOW")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property thingGroupIndexingConfiguration Thing group indexing configuration. See below.
 * @property thingIndexingConfiguration Thing indexing configuration. See below.
 */
public data class IndexingConfigurationArgs(
    public val thingGroupIndexingConfiguration:
    Output<IndexingConfigurationThingGroupIndexingConfigurationArgs>? = null,
    public val thingIndexingConfiguration:
    Output<IndexingConfigurationThingIndexingConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.IndexingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.iot.IndexingConfigurationArgs =
        com.pulumi.aws.iot.IndexingConfigurationArgs.builder()
            .thingGroupIndexingConfiguration(
                thingGroupIndexingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .thingIndexingConfiguration(
                thingIndexingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IndexingConfigurationArgs].
 */
@PulumiTagMarker
public class IndexingConfigurationArgsBuilder internal constructor() {
    private var thingGroupIndexingConfiguration:
        Output<IndexingConfigurationThingGroupIndexingConfigurationArgs>? = null

    private var thingIndexingConfiguration:
        Output<IndexingConfigurationThingIndexingConfigurationArgs>? = null

    /**
     * @param value Thing group indexing configuration. See below.
     */
    @JvmName("astnbxihfvocqkdj")
    public suspend
    fun thingGroupIndexingConfiguration(`value`: Output<IndexingConfigurationThingGroupIndexingConfigurationArgs>) {
        this.thingGroupIndexingConfiguration = value
    }

    /**
     * @param value Thing indexing configuration. See below.
     */
    @JvmName("dbadrhglpdjtooic")
    public suspend
    fun thingIndexingConfiguration(`value`: Output<IndexingConfigurationThingIndexingConfigurationArgs>) {
        this.thingIndexingConfiguration = value
    }

    /**
     * @param value Thing group indexing configuration. See below.
     */
    @JvmName("dukhthvygckwwtqx")
    public suspend
    fun thingGroupIndexingConfiguration(`value`: IndexingConfigurationThingGroupIndexingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingGroupIndexingConfiguration = mapped
    }

    /**
     * @param argument Thing group indexing configuration. See below.
     */
    @JvmName("mfefdueimkmiokyv")
    public suspend
    fun thingGroupIndexingConfiguration(argument: suspend IndexingConfigurationThingGroupIndexingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IndexingConfigurationThingGroupIndexingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.thingGroupIndexingConfiguration = mapped
    }

    /**
     * @param value Thing indexing configuration. See below.
     */
    @JvmName("vgcafeijhfuonavo")
    public suspend
    fun thingIndexingConfiguration(`value`: IndexingConfigurationThingIndexingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingIndexingConfiguration = mapped
    }

    /**
     * @param argument Thing indexing configuration. See below.
     */
    @JvmName("tpsjdexdurdnbqwq")
    public suspend
    fun thingIndexingConfiguration(argument: suspend IndexingConfigurationThingIndexingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IndexingConfigurationThingIndexingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.thingIndexingConfiguration = mapped
    }

    internal fun build(): IndexingConfigurationArgs = IndexingConfigurationArgs(
        thingGroupIndexingConfiguration = thingGroupIndexingConfiguration,
        thingIndexingConfiguration = thingIndexingConfiguration,
    )
}
