@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.IotFunctions.getEndpointPlain
import com.pulumi.aws.iot.IotFunctions.getRegistrationCodePlain
import com.pulumi.aws.iot.kotlin.inputs.GetEndpointPlainArgs
import com.pulumi.aws.iot.kotlin.inputs.GetEndpointPlainArgsBuilder
import com.pulumi.aws.iot.kotlin.outputs.GetEndpointResult
import com.pulumi.aws.iot.kotlin.outputs.GetRegistrationCodeResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.iot.kotlin.outputs.GetEndpointResult.Companion.toKotlin as getEndpointResultToKotlin
import com.pulumi.aws.iot.kotlin.outputs.GetRegistrationCodeResult.Companion.toKotlin as getRegistrationCodeResultToKotlin

public object IotFunctions {
    /**
     * Returns a unique endpoint specific to the AWS account making the call.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iot.IotFunctions;
     * import com.pulumi.aws.iot.inputs.GetEndpointArgs;
     * import com.pulumi.kubernetes.kubernetes_pod;
     * import com.pulumi.kubernetes.Kubernetes_podArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IotFunctions.getEndpoint();
     *         var agent = new Kubernetes_pod("agent", Kubernetes_podArgs.builder()
     *             .metadata(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *             .spec(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEndpoint.
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(argument: GetEndpointPlainArgs): GetEndpointResult =
        getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())

    /**
     * @see [getEndpoint].
     * @param endpointType Endpoint type. Valid values: `iot:CredentialProvider`, `iot:Data`, `iot:Data-ATS`, `iot:Jobs`.
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(endpointType: String? = null): GetEndpointResult {
        val argument = GetEndpointPlainArgs(
            endpointType = endpointType,
        )
        return getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iot&#46;kotlin&#46;inputs&#46;GetEndpointPlainArgs].
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(argument: suspend GetEndpointPlainArgsBuilder.() -> Unit):
        GetEndpointResult {
        val builder = GetEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointResultToKotlin(getEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a registration code used to register a CA certificate with AWS IoT.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iot.IotFunctions;
     * import com.pulumi.tls.PrivateKey;
     * import com.pulumi.tls.PrivateKeyArgs;
     * import com.pulumi.tls.CertRequest;
     * import com.pulumi.tls.CertRequestArgs;
     * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IotFunctions.getRegistrationCode();
     *         var verificationPrivateKey = new PrivateKey("verificationPrivateKey", PrivateKeyArgs.builder()
     *             .algorithm("RSA")
     *             .build());
     *         var verificationCertRequest = new CertRequest("verificationCertRequest", CertRequestArgs.builder()
     *             .keyAlgorithm("RSA")
     *             .privateKeyPem(verificationPrivateKey.privateKeyPem())
     *             .subject(CertRequestSubjectArgs.builder()
     *                 .commonName(example.applyValue(getRegistrationCodeResult -> getRegistrationCodeResult.registrationCode()))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iot.IotFunctions;
     * import com.pulumi.tls.PrivateKey;
     * import com.pulumi.tls.PrivateKeyArgs;
     * import com.pulumi.tls.CertRequest;
     * import com.pulumi.tls.CertRequestArgs;
     * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IotFunctions.getRegistrationCode();
     *         var verificationPrivateKey = new PrivateKey("verificationPrivateKey", PrivateKeyArgs.builder()
     *             .algorithm("RSA")
     *             .build());
     *         var verificationCertRequest = new CertRequest("verificationCertRequest", CertRequestArgs.builder()
     *             .keyAlgorithm("RSA")
     *             .privateKeyPem(verificationPrivateKey.privateKeyPem())
     *             .subject(CertRequestSubjectArgs.builder()
     *                 .commonName(example.applyValue(getRegistrationCodeResult -> getRegistrationCodeResult.registrationCode()))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument Gets a registration code used to register a CA certificate with AWS IoT.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iot.IotFunctions;
     * import com.pulumi.tls.PrivateKey;
     * import com.pulumi.tls.PrivateKeyArgs;
     * import com.pulumi.tls.CertRequest;
     * import com.pulumi.tls.CertRequestArgs;
     * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IotFunctions.getRegistrationCode();
     *         var verificationPrivateKey = new PrivateKey("verificationPrivateKey", PrivateKeyArgs.builder()
     *             .algorithm("RSA")
     *             .build());
     *         var verificationCertRequest = new CertRequest("verificationCertRequest", CertRequestArgs.builder()
     *             .keyAlgorithm("RSA")
     *             .privateKeyPem(verificationPrivateKey.privateKeyPem())
     *             .subject(CertRequestSubjectArgs.builder()
     *                 .commonName(example.applyValue(getRegistrationCodeResult -> getRegistrationCodeResult.registrationCode()))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iot.IotFunctions;
     * import com.pulumi.tls.PrivateKey;
     * import com.pulumi.tls.PrivateKeyArgs;
     * import com.pulumi.tls.CertRequest;
     * import com.pulumi.tls.CertRequestArgs;
     * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IotFunctions.getRegistrationCode();
     *         var verificationPrivateKey = new PrivateKey("verificationPrivateKey", PrivateKeyArgs.builder()
     *             .algorithm("RSA")
     *             .build());
     *         var verificationCertRequest = new CertRequest("verificationCertRequest", CertRequestArgs.builder()
     *             .keyAlgorithm("RSA")
     *             .privateKeyPem(verificationPrivateKey.privateKeyPem())
     *             .subject(CertRequestSubjectArgs.builder()
     *                 .commonName(example.applyValue(getRegistrationCodeResult -> getRegistrationCodeResult.registrationCode()))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @return A collection of values returned by getRegistrationCode.
     */
    public suspend fun getRegistrationCode(): GetRegistrationCodeResult =
        getRegistrationCodeResultToKotlin(getRegistrationCodePlain().await())
}
