@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.LoggingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage [default logging options](https://docs.aws.amazon.com/iot/latest/developerguide/configure-logging.html#configure-logging-console).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.LoggingOptions;
 * import com.pulumi.aws.iot.LoggingOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingOptions("example", LoggingOptionsArgs.builder()
 *             .defaultLogLevel("WARN")
 *             .roleArn(aws_iam_role.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * @property defaultLogLevel The default logging level. Valid Values: `"DEBUG"`, `"INFO"`, `"ERROR"`, `"WARN"`, `"DISABLED"`.
 * @property disableAllLogs If `true` all logs are disabled. The default is `false`.
 * @property roleArn The ARN of the role that allows IoT to write to Cloudwatch logs.
 */
public data class LoggingOptionsArgs(
    public val defaultLogLevel: Output<String>? = null,
    public val disableAllLogs: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.LoggingOptionsArgs> {
    override fun toJava(): com.pulumi.aws.iot.LoggingOptionsArgs =
        com.pulumi.aws.iot.LoggingOptionsArgs.builder()
            .defaultLogLevel(defaultLogLevel?.applyValue({ args0 -> args0 }))
            .disableAllLogs(disableAllLogs?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoggingOptionsArgs].
 */
@PulumiTagMarker
public class LoggingOptionsArgsBuilder internal constructor() {
    private var defaultLogLevel: Output<String>? = null

    private var disableAllLogs: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The default logging level. Valid Values: `"DEBUG"`, `"INFO"`, `"ERROR"`, `"WARN"`, `"DISABLED"`.
     */
    @JvmName("cnnglwkufslgtsji")
    public suspend fun defaultLogLevel(`value`: Output<String>) {
        this.defaultLogLevel = value
    }

    /**
     * @param value If `true` all logs are disabled. The default is `false`.
     */
    @JvmName("dwdbaaapavgsbisr")
    public suspend fun disableAllLogs(`value`: Output<Boolean>) {
        this.disableAllLogs = value
    }

    /**
     * @param value The ARN of the role that allows IoT to write to Cloudwatch logs.
     */
    @JvmName("kwjgjtvbbmhytkea")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The default logging level. Valid Values: `"DEBUG"`, `"INFO"`, `"ERROR"`, `"WARN"`, `"DISABLED"`.
     */
    @JvmName("fvjpajssydwsyycy")
    public suspend fun defaultLogLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLogLevel = mapped
    }

    /**
     * @param value If `true` all logs are disabled. The default is `false`.
     */
    @JvmName("nxbbnjibubwkjydh")
    public suspend fun disableAllLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableAllLogs = mapped
    }

    /**
     * @param value The ARN of the role that allows IoT to write to Cloudwatch logs.
     */
    @JvmName("spvocudilmrimods")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): LoggingOptionsArgs = LoggingOptionsArgs(
        defaultLogLevel = defaultLogLevel,
        disableAllLogs = disableAllLogs,
        roleArn = roleArn,
    )
}
