@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.PolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IoT policy.
 * > **NOTE on policy versions:** Updating this resource creates a new, default policy version. If updating the resource would exceed the maximum number of versions (5), the oldest non-default version of the policy is deleted before the new policy version is created.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Policy;
 * import com.pulumi.aws.iot.PolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pubsub = new Policy("pubsub", PolicyArgs.builder()
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("iot:*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT policies using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:iot/policy:Policy pubsub PubSubToAnyTopic
 * ```
 * @property name The name of the policy.
 * @property policy The policy document. This is a JSON formatted string. Use the [IoT Developer Guide](http://docs.aws.amazon.com/iot/latest/developerguide/iot-policies.html) for more information on IoT Policies.
 */
public data class PolicyArgs(
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.PolicyArgs> {
    override fun toJava(): com.pulumi.aws.iot.PolicyArgs = com.pulumi.aws.iot.PolicyArgs.builder()
        .name(name?.applyValue({ args0 -> args0 }))
        .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The name of the policy.
     */
    @JvmName("ntdychvbftcweoxe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The policy document. This is a JSON formatted string. Use the [IoT Developer Guide](http://docs.aws.amazon.com/iot/latest/developerguide/iot-policies.html) for more information on IoT Policies.
     */
    @JvmName("yqcoweiynqjwghkg")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("qoibbjcgjdapwwbq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The policy document. This is a JSON formatted string. Use the [IoT Developer Guide](http://docs.aws.amazon.com/iot/latest/developerguide/iot-policies.html) for more information on IoT Policies.
     */
    @JvmName("qethpdlnpgneqmra")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        name = name,
        policy = policy,
    )
}
