@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolicyAttachment].
 */
@PulumiTagMarker
public class PolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyAttachmentArgs = PolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = PolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PolicyAttachment {
        val builtJavaResource = com.pulumi.aws.iot.PolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PolicyAttachment(builtJavaResource)
    }
}

/**
 * Provides an IoT policy attachment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iot.Policy;
 * import com.pulumi.aws.iot.PolicyArgs;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import com.pulumi.aws.iot.PolicyAttachment;
 * import com.pulumi.aws.iot.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var pubsubPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("iot:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var pubsubPolicy = new Policy("pubsubPolicy", PolicyArgs.builder()
 *             .policy(pubsubPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .csr(Files.readString(Paths.get("csr.pem")))
 *             .active(true)
 *             .build());
 *         var att = new PolicyAttachment("att", PolicyAttachmentArgs.builder()
 *             .policy(pubsubPolicy.name())
 *             .target(cert.arn())
 *             .build());
 *     }
 * }
 * ```
 */
public class PolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.iot.PolicyAttachment,
) : KotlinCustomResource(javaResource, PolicyAttachmentMapper) {
    /**
     * The name of the policy to attach.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The identity to which the policy is attached.
     */
    public val target: Output<String>
        get() = javaResource.target().applyValue({ args0 -> args0 })
}

public object PolicyAttachmentMapper : ResourceMapper<PolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.PolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): PolicyAttachment = PolicyAttachment(
        javaResource as
            com.pulumi.aws.iot.PolicyAttachment,
    )
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyAttachment].
 */
public suspend fun policyAttachment(
    name: String,
    block: suspend PolicyAttachmentResourceBuilder.() -> Unit,
): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyAttachment(name: String): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
