@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.PolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IoT policy attachment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iot.Policy;
 * import com.pulumi.aws.iot.PolicyArgs;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import com.pulumi.aws.iot.PolicyAttachment;
 * import com.pulumi.aws.iot.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var pubsubPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("iot:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var pubsubPolicy = new Policy("pubsubPolicy", PolicyArgs.builder()
 *             .policy(pubsubPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .csr(Files.readString(Paths.get("csr.pem")))
 *             .active(true)
 *             .build());
 *         var att = new PolicyAttachment("att", PolicyAttachmentArgs.builder()
 *             .policy(pubsubPolicy.name())
 *             .target(cert.arn())
 *             .build());
 *     }
 * }
 * ```
 * @property policy The name of the policy to attach.
 * @property target The identity to which the policy is attached.
 */
public data class PolicyAttachmentArgs(
    public val policy: Output<String>? = null,
    public val target: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.PolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.iot.PolicyAttachmentArgs =
        com.pulumi.aws.iot.PolicyAttachmentArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyAttachmentArgs].
 */
@PulumiTagMarker
public class PolicyAttachmentArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value The name of the policy to attach.
     */
    @JvmName("wdcldtrbarslxdlu")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The identity to which the policy is attached.
     */
    @JvmName("adhocapdwyigfsus")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The name of the policy to attach.
     */
    @JvmName("eeqlflppbtyobrlt")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The identity to which the policy is attached.
     */
    @JvmName("tcybyaiosmvaimmv")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): PolicyAttachmentArgs = PolicyAttachmentArgs(
        policy = policy,
        target = target,
    )
}
