@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.ProvisioningTemplatePreProvisioningHook
import com.pulumi.aws.iot.kotlin.outputs.ProvisioningTemplatePreProvisioningHook.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ProvisioningTemplate].
 */
@PulumiTagMarker
public class ProvisioningTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProvisioningTemplateArgs = ProvisioningTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProvisioningTemplateArgsBuilder.() -> Unit) {
        val builder = ProvisioningTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProvisioningTemplate {
        val builtJavaResource = com.pulumi.aws.iot.ProvisioningTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProvisioningTemplate(builtJavaResource)
    }
}

/**
 * Manages an IoT fleet provisioning template. For more info, see the AWS documentation on [fleet provisioning](https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.iot.Policy;
 * import com.pulumi.aws.iot.PolicyArgs;
 * import com.pulumi.aws.iot.ProvisioningTemplate;
 * import com.pulumi.aws.iot.ProvisioningTemplateArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var iotAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("iot.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var iotFleetProvisioning = new Role("iotFleetProvisioning", RoleArgs.builder()
 *             .path("/service-role/")
 *             .assumeRolePolicy(iotAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var iotFleetProvisioningRegistration = new RolePolicyAttachment("iotFleetProvisioningRegistration", RolePolicyAttachmentArgs.builder()
 *             .role(iotFleetProvisioning.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration")
 *             .build());
 *         final var devicePolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("iot:Subscribe")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var devicePolicyPolicy = new Policy("devicePolicyPolicy", PolicyArgs.builder()
 *             .policy(devicePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var fleet = new ProvisioningTemplate("fleet", ProvisioningTemplateArgs.builder()
 *             .description("My provisioning template")
 *             .provisioningRoleArn(iotFleetProvisioning.arn())
 *             .enabled(true)
 *             .templateBody(devicePolicyPolicy.name().applyValue(name -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Parameters", jsonObject(
 *                         jsonProperty("SerialNumber", jsonObject(
 *                             jsonProperty("Type", "String")
 *                         ))
 *                     )),
 *                     jsonProperty("Resources", jsonObject(
 *                         jsonProperty("certificate", jsonObject(
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("CertificateId", jsonObject(
 *                                     jsonProperty("Ref", "AWS::IoT::Certificate::Id")
 *                                 )),
 *                                 jsonProperty("Status", "Active")
 *                             )),
 *                             jsonProperty("Type", "AWS::IoT::Certificate")
 *                         )),
 *                         jsonProperty("policy", jsonObject(
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("PolicyName", name)
 *                             )),
 *                             jsonProperty("Type", "AWS::IoT::Policy")
 *                         ))
 *                     ))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT fleet provisioning templates using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:iot/provisioningTemplate:ProvisioningTemplate fleet FleetProvisioningTemplate
 * ```
 *
 */
public class ProvisioningTemplate internal constructor(
    override val javaResource: com.pulumi.aws.iot.ProvisioningTemplate,
) : KotlinCustomResource(javaResource, ProvisioningTemplateMapper) {
    /**
     * The ARN that identifies the provisioning template.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The default version of the fleet provisioning template.
     */
    public val defaultVersionId: Output<Int>
        get() = javaResource.defaultVersionId().applyValue({ args0 -> args0 })

    /**
     * The description of the fleet provisioning template.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * True to enable the fleet provisioning template, otherwise false.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the fleet provisioning template.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a pre-provisioning hook template. Details below.
     */
    public val preProvisioningHook: Output<ProvisioningTemplatePreProvisioningHook>?
        get() = javaResource.preProvisioningHook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
     */
    public val provisioningRoleArn: Output<String>
        get() = javaResource.provisioningRoleArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The JSON formatted contents of the fleet provisioning template.
     */
    public val templateBody: Output<String>
        get() = javaResource.templateBody().applyValue({ args0 -> args0 })

    /**
     * The type you define in a provisioning template.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProvisioningTemplateMapper : ResourceMapper<ProvisioningTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.ProvisioningTemplate::class == javaResource::class

    override fun map(javaResource: Resource): ProvisioningTemplate = ProvisioningTemplate(
        javaResource
            as com.pulumi.aws.iot.ProvisioningTemplate,
    )
}

/**
 * @see [ProvisioningTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProvisioningTemplate].
 */
public suspend fun provisioningTemplate(
    name: String,
    block: suspend ProvisioningTemplateResourceBuilder.() -> Unit,
): ProvisioningTemplate {
    val builder = ProvisioningTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProvisioningTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun provisioningTemplate(name: String): ProvisioningTemplate {
    val builder = ProvisioningTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
