@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ProvisioningTemplateArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.ProvisioningTemplatePreProvisioningHookArgs
import com.pulumi.aws.iot.kotlin.inputs.ProvisioningTemplatePreProvisioningHookArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an IoT fleet provisioning template. For more info, see the AWS documentation on [fleet provisioning](https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.iot.Policy;
 * import com.pulumi.aws.iot.PolicyArgs;
 * import com.pulumi.aws.iot.ProvisioningTemplate;
 * import com.pulumi.aws.iot.ProvisioningTemplateArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var iotAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("iot.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var iotFleetProvisioning = new Role("iotFleetProvisioning", RoleArgs.builder()
 *             .path("/service-role/")
 *             .assumeRolePolicy(iotAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var iotFleetProvisioningRegistration = new RolePolicyAttachment("iotFleetProvisioningRegistration", RolePolicyAttachmentArgs.builder()
 *             .role(iotFleetProvisioning.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration")
 *             .build());
 *         final var devicePolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("iot:Subscribe")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var devicePolicyPolicy = new Policy("devicePolicyPolicy", PolicyArgs.builder()
 *             .policy(devicePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var fleet = new ProvisioningTemplate("fleet", ProvisioningTemplateArgs.builder()
 *             .description("My provisioning template")
 *             .provisioningRoleArn(iotFleetProvisioning.arn())
 *             .enabled(true)
 *             .templateBody(devicePolicyPolicy.name().applyValue(name -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Parameters", jsonObject(
 *                         jsonProperty("SerialNumber", jsonObject(
 *                             jsonProperty("Type", "String")
 *                         ))
 *                     )),
 *                     jsonProperty("Resources", jsonObject(
 *                         jsonProperty("certificate", jsonObject(
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("CertificateId", jsonObject(
 *                                     jsonProperty("Ref", "AWS::IoT::Certificate::Id")
 *                                 )),
 *                                 jsonProperty("Status", "Active")
 *                             )),
 *                             jsonProperty("Type", "AWS::IoT::Certificate")
 *                         )),
 *                         jsonProperty("policy", jsonObject(
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("PolicyName", name)
 *                             )),
 *                             jsonProperty("Type", "AWS::IoT::Policy")
 *                         ))
 *                     ))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT fleet provisioning templates using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:iot/provisioningTemplate:ProvisioningTemplate fleet FleetProvisioningTemplate
 * ```
 * @property description The description of the fleet provisioning template.
 * @property enabled True to enable the fleet provisioning template, otherwise false.
 * @property name The name of the fleet provisioning template.
 * @property preProvisioningHook Creates a pre-provisioning hook template. Details below.
 * @property provisioningRoleArn The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property templateBody The JSON formatted contents of the fleet provisioning template.
 * @property type The type you define in a provisioning template.
 */
public data class ProvisioningTemplateArgs(
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val preProvisioningHook: Output<ProvisioningTemplatePreProvisioningHookArgs>? = null,
    public val provisioningRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateBody: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ProvisioningTemplateArgs> {
    override fun toJava(): com.pulumi.aws.iot.ProvisioningTemplateArgs =
        com.pulumi.aws.iot.ProvisioningTemplateArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .preProvisioningHook(
                preProvisioningHook?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .provisioningRoleArn(provisioningRoleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProvisioningTemplateArgs].
 */
@PulumiTagMarker
public class ProvisioningTemplateArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var preProvisioningHook: Output<ProvisioningTemplatePreProvisioningHookArgs>? = null

    private var provisioningRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateBody: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The description of the fleet provisioning template.
     */
    @JvmName("ebmjqxvngwrbkehq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value True to enable the fleet provisioning template, otherwise false.
     */
    @JvmName("mxbywlkpjtsgwqnx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the fleet provisioning template.
     */
    @JvmName("qmmsbcdmufrcghqo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a pre-provisioning hook template. Details below.
     */
    @JvmName("acxhjannbvkbemin")
    public suspend
    fun preProvisioningHook(`value`: Output<ProvisioningTemplatePreProvisioningHookArgs>) {
        this.preProvisioningHook = value
    }

    /**
     * @param value The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
     */
    @JvmName("mlynaoyhcjdgkjhh")
    public suspend fun provisioningRoleArn(`value`: Output<String>) {
        this.provisioningRoleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rkdjxketmyxgfbpy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The JSON formatted contents of the fleet provisioning template.
     */
    @JvmName("wesqbtmwseutqdnx")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value The type you define in a provisioning template.
     */
    @JvmName("kjyfovqvudoeuvoa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The description of the fleet provisioning template.
     */
    @JvmName("lcmcewaqwipkgdus")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value True to enable the fleet provisioning template, otherwise false.
     */
    @JvmName("vsbtyrogdisjxjrl")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The name of the fleet provisioning template.
     */
    @JvmName("iifkuewbrojhqyip")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a pre-provisioning hook template. Details below.
     */
    @JvmName("mumjwvkupffmypbw")
    public suspend fun preProvisioningHook(`value`: ProvisioningTemplatePreProvisioningHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preProvisioningHook = mapped
    }

    /**
     * @param argument Creates a pre-provisioning hook template. Details below.
     */
    @JvmName("xqwmicfhjhhhuafu")
    public suspend
    fun preProvisioningHook(argument: suspend ProvisioningTemplatePreProvisioningHookArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisioningTemplatePreProvisioningHookArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.preProvisioningHook = mapped
    }

    /**
     * @param value The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
     */
    @JvmName("hpnutoxprcvkxkks")
    public suspend fun provisioningRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningRoleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jbnofxvrkmyquknh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bepjhyjvyccnlxck")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The JSON formatted contents of the fleet provisioning template.
     */
    @JvmName("fgjehypujtxbkutd")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value The type you define in a provisioning template.
     */
    @JvmName("uoaloeesiwgfuwmp")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProvisioningTemplateArgs = ProvisioningTemplateArgs(
        description = description,
        enabled = enabled,
        name = name,
        preProvisioningHook = preProvisioningHook,
        provisioningRoleArn = provisioningRoleArn,
        tags = tags,
        templateBody = templateBody,
        type = type,
    )
}
