@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.RoleAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IoT role alias.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iot.RoleAlias;
 * import com.pulumi.aws.iot.RoleAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .effect("Allow")
 *             .principals(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .actions("sts:AssumeRole")
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var alias = new RoleAlias("alias", RoleAliasArgs.builder()
 *             .alias("Thermostat-dynamodb-access-role-alias")
 *             .roleArn(role.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IOT Role Alias using the alias. For example:
 * ```sh
 *  $ pulumi import aws:iot/roleAlias:RoleAlias example myalias
 * ```
 * @property alias The name of the role alias.
 * @property credentialDuration The duration of the credential, in seconds. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 900 seconds (15 minutes) to 43200 seconds (12 hours).
 * @property roleArn The identity of the role to which the alias refers.
 */
public data class RoleAliasArgs(
    public val alias: Output<String>? = null,
    public val credentialDuration: Output<Int>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.RoleAliasArgs> {
    override fun toJava(): com.pulumi.aws.iot.RoleAliasArgs =
        com.pulumi.aws.iot.RoleAliasArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .credentialDuration(credentialDuration?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleAliasArgs].
 */
@PulumiTagMarker
public class RoleAliasArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var credentialDuration: Output<Int>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The name of the role alias.
     */
    @JvmName("sugqvstucsjpcxgh")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value The duration of the credential, in seconds. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 900 seconds (15 minutes) to 43200 seconds (12 hours).
     */
    @JvmName("ssxjmxvbjyekxjda")
    public suspend fun credentialDuration(`value`: Output<Int>) {
        this.credentialDuration = value
    }

    /**
     * @param value The identity of the role to which the alias refers.
     */
    @JvmName("imgplkobkteberwy")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the role alias.
     */
    @JvmName("cfebkssxpwcktaig")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value The duration of the credential, in seconds. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 900 seconds (15 minutes) to 43200 seconds (12 hours).
     */
    @JvmName("elkocxssssvmaxwt")
    public suspend fun credentialDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialDuration = mapped
    }

    /**
     * @param value The identity of the role to which the alias refers.
     */
    @JvmName("vfdxivscaowpduvk")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): RoleAliasArgs = RoleAliasArgs(
        alias = alias,
        credentialDuration = credentialDuration,
        roleArn = roleArn,
    )
}
