@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.ThingGroupMetadata
import com.pulumi.aws.iot.kotlin.outputs.ThingGroupProperties
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.iot.kotlin.outputs.ThingGroupMetadata.Companion.toKotlin as thingGroupMetadataToKotlin
import com.pulumi.aws.iot.kotlin.outputs.ThingGroupProperties.Companion.toKotlin as thingGroupPropertiesToKotlin

/**
 * Builder for [ThingGroup].
 */
@PulumiTagMarker
public class ThingGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThingGroupArgs = ThingGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThingGroupArgsBuilder.() -> Unit) {
        val builder = ThingGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ThingGroup {
        val builtJavaResource = com.pulumi.aws.iot.ThingGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ThingGroup(builtJavaResource)
    }
}

/**
 * Manages an AWS IoT Thing Group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.ThingGroup;
 * import com.pulumi.aws.iot.ThingGroupArgs;
 * import com.pulumi.aws.iot.inputs.ThingGroupPropertiesArgs;
 * import com.pulumi.aws.iot.inputs.ThingGroupPropertiesAttributePayloadArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new ThingGroup("parent");
 *         var example = new ThingGroup("example", ThingGroupArgs.builder()
 *             .parentGroupName(parent.name())
 *             .properties(ThingGroupPropertiesArgs.builder()
 *                 .attributePayload(ThingGroupPropertiesAttributePayloadArgs.builder()
 *                     .attributes(Map.ofEntries(
 *                         Map.entry("One", "11111"),
 *                         Map.entry("Two", "TwoTwo")
 *                     ))
 *                     .build())
 *                 .description("This is my thing group")
 *                 .build())
 *             .tags(Map.of("managed", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT Things Groups using the name. For example:
 * ```sh
 *  $ pulumi import aws:iot/thingGroup:ThingGroup example example
 * ```
 *
 */
public class ThingGroup internal constructor(
    override val javaResource: com.pulumi.aws.iot.ThingGroup,
) : KotlinCustomResource(javaResource, ThingGroupMapper) {
    /**
     * The ARN of the Thing Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val metadatas: Output<List<ThingGroupMetadata>>
        get() = javaResource.metadatas().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    thingGroupMetadataToKotlin(args0)
                })
            })
        })

    /**
     * The name of the Thing Group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the parent Thing Group.
     */
    public val parentGroupName: Output<String>?
        get() = javaResource.parentGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Thing Group properties. Defined below.
     */
    public val properties: Output<ThingGroupProperties>?
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    thingGroupPropertiesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key-value mapping of resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The current version of the Thing Group record in the registry.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ThingGroupMapper : ResourceMapper<ThingGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.ThingGroup::class == javaResource::class

    override fun map(javaResource: Resource): ThingGroup = ThingGroup(
        javaResource as
            com.pulumi.aws.iot.ThingGroup,
    )
}

/**
 * @see [ThingGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ThingGroup].
 */
public suspend fun thingGroup(name: String, block: suspend ThingGroupResourceBuilder.() -> Unit):
    ThingGroup {
    val builder = ThingGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ThingGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun thingGroup(name: String): ThingGroup {
    val builder = ThingGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
