@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ThingGroupArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.ThingGroupPropertiesArgs
import com.pulumi.aws.iot.kotlin.inputs.ThingGroupPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS IoT Thing Group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.ThingGroup;
 * import com.pulumi.aws.iot.ThingGroupArgs;
 * import com.pulumi.aws.iot.inputs.ThingGroupPropertiesArgs;
 * import com.pulumi.aws.iot.inputs.ThingGroupPropertiesAttributePayloadArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new ThingGroup("parent");
 *         var example = new ThingGroup("example", ThingGroupArgs.builder()
 *             .parentGroupName(parent.name())
 *             .properties(ThingGroupPropertiesArgs.builder()
 *                 .attributePayload(ThingGroupPropertiesAttributePayloadArgs.builder()
 *                     .attributes(Map.ofEntries(
 *                         Map.entry("One", "11111"),
 *                         Map.entry("Two", "TwoTwo")
 *                     ))
 *                     .build())
 *                 .description("This is my thing group")
 *                 .build())
 *             .tags(Map.of("managed", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT Things Groups using the name. For example:
 * ```sh
 *  $ pulumi import aws:iot/thingGroup:ThingGroup example example
 * ```
 * @property name The name of the Thing Group.
 * @property parentGroupName The name of the parent Thing Group.
 * @property properties The Thing Group properties. Defined below.
 * @property tags Key-value mapping of resource tags
 */
public data class ThingGroupArgs(
    public val name: Output<String>? = null,
    public val parentGroupName: Output<String>? = null,
    public val properties: Output<ThingGroupPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ThingGroupArgs> {
    override fun toJava(): com.pulumi.aws.iot.ThingGroupArgs =
        com.pulumi.aws.iot.ThingGroupArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .parentGroupName(parentGroupName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ThingGroupArgs].
 */
@PulumiTagMarker
public class ThingGroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parentGroupName: Output<String>? = null

    private var properties: Output<ThingGroupPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Thing Group.
     */
    @JvmName("nvnwdueukaibuehw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the parent Thing Group.
     */
    @JvmName("lduqxduogopbcxpg")
    public suspend fun parentGroupName(`value`: Output<String>) {
        this.parentGroupName = value
    }

    /**
     * @param value The Thing Group properties. Defined below.
     */
    @JvmName("sbdnopopusukujbh")
    public suspend fun properties(`value`: Output<ThingGroupPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Key-value mapping of resource tags
     */
    @JvmName("dofttcfttrmgirac")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Thing Group.
     */
    @JvmName("sajvsfilcdhomrnt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the parent Thing Group.
     */
    @JvmName("aivpfcotlfnwsjgu")
    public suspend fun parentGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentGroupName = mapped
    }

    /**
     * @param value The Thing Group properties. Defined below.
     */
    @JvmName("jvoirvqvyaqyflnu")
    public suspend fun properties(`value`: ThingGroupPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The Thing Group properties. Defined below.
     */
    @JvmName("jussdvgponapdcbh")
    public suspend fun properties(argument: suspend ThingGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ThingGroupPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Key-value mapping of resource tags
     */
    @JvmName("jgbalxocyliqaudb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags
     */
    @JvmName("wdaihfmwmeoryxpo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ThingGroupArgs = ThingGroupArgs(
        name = name,
        parentGroupName = parentGroupName,
        properties = properties,
        tags = tags,
    )
}
