@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ThingGroupMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Adds an IoT Thing to an IoT Thing Group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.ThingGroupMembership;
 * import com.pulumi.aws.iot.ThingGroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ThingGroupMembership("example", ThingGroupMembershipArgs.builder()
 *             .overrideDynamicGroup(true)
 *             .thingGroupName("example-group")
 *             .thingName("example-thing")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT Thing Group Membership using the thing group name and thing name. For example:
 * ```sh
 *  $ pulumi import aws:iot/thingGroupMembership:ThingGroupMembership example thing_group_name/thing_name
 * ```
 * @property overrideDynamicGroup Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.
 * @property thingGroupName The name of the group to which you are adding a thing.
 * @property thingName The name of the thing to add to a group.
 */
public data class ThingGroupMembershipArgs(
    public val overrideDynamicGroup: Output<Boolean>? = null,
    public val thingGroupName: Output<String>? = null,
    public val thingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ThingGroupMembershipArgs> {
    override fun toJava(): com.pulumi.aws.iot.ThingGroupMembershipArgs =
        com.pulumi.aws.iot.ThingGroupMembershipArgs.builder()
            .overrideDynamicGroup(overrideDynamicGroup?.applyValue({ args0 -> args0 }))
            .thingGroupName(thingGroupName?.applyValue({ args0 -> args0 }))
            .thingName(thingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThingGroupMembershipArgs].
 */
@PulumiTagMarker
public class ThingGroupMembershipArgsBuilder internal constructor() {
    private var overrideDynamicGroup: Output<Boolean>? = null

    private var thingGroupName: Output<String>? = null

    private var thingName: Output<String>? = null

    /**
     * @param value Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.
     */
    @JvmName("dxpllwsmuxauagvc")
    public suspend fun overrideDynamicGroup(`value`: Output<Boolean>) {
        this.overrideDynamicGroup = value
    }

    /**
     * @param value The name of the group to which you are adding a thing.
     */
    @JvmName("vrwkqrqoosrctndt")
    public suspend fun thingGroupName(`value`: Output<String>) {
        this.thingGroupName = value
    }

    /**
     * @param value The name of the thing to add to a group.
     */
    @JvmName("brgqggxesdfhmvor")
    public suspend fun thingName(`value`: Output<String>) {
        this.thingName = value
    }

    /**
     * @param value Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.
     */
    @JvmName("uikuwdwfnugsyidn")
    public suspend fun overrideDynamicGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideDynamicGroup = mapped
    }

    /**
     * @param value The name of the group to which you are adding a thing.
     */
    @JvmName("rpoeppwtrmwxtjol")
    public suspend fun thingGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingGroupName = mapped
    }

    /**
     * @param value The name of the thing to add to a group.
     */
    @JvmName("xpldftwrrhcjukhw")
    public suspend fun thingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingName = mapped
    }

    internal fun build(): ThingGroupMembershipArgs = ThingGroupMembershipArgs(
        overrideDynamicGroup = overrideDynamicGroup,
        thingGroupName = thingGroupName,
        thingName = thingName,
    )
}
