@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ThingPrincipalAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches Principal to AWS IoT Thing.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Thing;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import com.pulumi.aws.iot.ThingPrincipalAttachment;
 * import com.pulumi.aws.iot.ThingPrincipalAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Thing("example");
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .csr(Files.readString(Paths.get("csr.pem")))
 *             .active(true)
 *             .build());
 *         var att = new ThingPrincipalAttachment("att", ThingPrincipalAttachmentArgs.builder()
 *             .principal(cert.arn())
 *             .thing(example.name())
 *             .build());
 *     }
 * }
 * ```
 * @property principal The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
 * @property thing The name of the thing.
 */
public data class ThingPrincipalAttachmentArgs(
    public val principal: Output<String>? = null,
    public val thing: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ThingPrincipalAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.iot.ThingPrincipalAttachmentArgs =
        com.pulumi.aws.iot.ThingPrincipalAttachmentArgs.builder()
            .principal(principal?.applyValue({ args0 -> args0 }))
            .thing(thing?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThingPrincipalAttachmentArgs].
 */
@PulumiTagMarker
public class ThingPrincipalAttachmentArgsBuilder internal constructor() {
    private var principal: Output<String>? = null

    private var thing: Output<String>? = null

    /**
     * @param value The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
     */
    @JvmName("uiddpdeesxmebclv")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value The name of the thing.
     */
    @JvmName("flmtaxknkrfnsnni")
    public suspend fun thing(`value`: Output<String>) {
        this.thing = value
    }

    /**
     * @param value The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
     */
    @JvmName("gwcxjqcpcwudgjhb")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param value The name of the thing.
     */
    @JvmName("qprkjydienehhpso")
    public suspend fun thing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thing = mapped
    }

    internal fun build(): ThingPrincipalAttachmentArgs = ThingPrincipalAttachmentArgs(
        principal = principal,
        thing = thing,
    )
}
