@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.ThingTypeProperties
import com.pulumi.aws.iot.kotlin.outputs.ThingTypeProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ThingType].
 */
@PulumiTagMarker
public class ThingTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThingTypeArgs = ThingTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThingTypeArgsBuilder.() -> Unit) {
        val builder = ThingTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ThingType {
        val builtJavaResource = com.pulumi.aws.iot.ThingType(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ThingType(builtJavaResource)
    }
}

/**
 * Creates and manages an AWS IoT Thing Type.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.ThingType;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new ThingType("foo");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IOT Thing Types using the name. For example:
 * ```sh
 *  $ pulumi import aws:iot/thingType:ThingType example example
 * ```
 *
 */
public class ThingType internal constructor(
    override val javaResource: com.pulumi.aws.iot.ThingType,
) : KotlinCustomResource(javaResource, ThingTypeMapper) {
    /**
     * The ARN of the created AWS IoT Thing Type.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether the thing type is deprecated. If true, no new things could be associated with this type.
     */
    public val deprecated: Output<Boolean>?
        get() = javaResource.deprecated().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the thing type.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * , Configuration block that can contain the following properties of the thing type:
     */
    public val properties: Output<ThingTypeProperties>?
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ThingTypeMapper : ResourceMapper<ThingType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.ThingType::class == javaResource::class

    override fun map(javaResource: Resource): ThingType = ThingType(
        javaResource as
            com.pulumi.aws.iot.ThingType,
    )
}

/**
 * @see [ThingType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ThingType].
 */
public suspend fun thingType(name: String, block: suspend ThingTypeResourceBuilder.() -> Unit):
    ThingType {
    val builder = ThingTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ThingType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun thingType(name: String): ThingType {
    val builder = ThingTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
