@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.TopicRuleArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchAlarmArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchAlarmArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchLogArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchLogArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchMetricArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchMetricArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDynamodbArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDynamodbArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDynamodbv2Args
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDynamodbv2ArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleElasticsearchArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleElasticsearchArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleErrorActionArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleErrorActionArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleFirehoseArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleFirehoseArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleHttpArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleHttpArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleIotAnalyticArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleIotAnalyticArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleIotEventArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleIotEventArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleKafkaArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleKafkaArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleKinesisArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleKinesisArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleLambdaArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleLambdaArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleRepublishArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleRepublishArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleS3Args
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleS3ArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleSnsArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleSnsArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleSqsArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleSqsArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleStepFunctionArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleStepFunctionArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleTimestreamArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleTimestreamArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iot.TopicRule;
 * import com.pulumi.aws.iot.TopicRuleArgs;
 * import com.pulumi.aws.iot.inputs.TopicRuleSnsArgs;
 * import com.pulumi.aws.iot.inputs.TopicRuleErrorActionArgs;
 * import com.pulumi.aws.iot.inputs.TopicRuleErrorActionSnsArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mytopic = new Topic("mytopic");
 *         var myerrortopic = new Topic("myerrortopic");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("iot.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var rule = new TopicRule("rule", TopicRuleArgs.builder()
 *             .description("Example rule")
 *             .enabled(true)
 *             .sql("SELECT * FROM 'topic/test'")
 *             .sqlVersion("2016-03-23")
 *             .sns(TopicRuleSnsArgs.builder()
 *                 .messageFormat("RAW")
 *                 .roleArn(role.arn())
 *                 .targetArn(mytopic.arn())
 *                 .build())
 *             .errorAction(TopicRuleErrorActionArgs.builder()
 *                 .sns(TopicRuleErrorActionSnsArgs.builder()
 *                     .messageFormat("RAW")
 *                     .roleArn(role.arn())
 *                     .targetArn(myerrortopic.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *         final var iamPolicyForLambdaPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("sns:Publish")
 *                 .resources(mytopic.arn())
 *                 .build())
 *             .build());
 *         var iamPolicyForLambdaRolePolicy = new RolePolicy("iamPolicyForLambdaRolePolicy", RolePolicyArgs.builder()
 *             .role(role.id())
 *             .policy(iamPolicyForLambdaPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(iamPolicyForLambdaPolicyDocument -> iamPolicyForLambdaPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT Topic Rules using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:iot/topicRule:TopicRule rule <name>
 * ```
 * @property cloudwatchAlarms
 * @property cloudwatchLogs
 * @property cloudwatchMetrics
 * @property description The description of the rule.
 * @property dynamodbs
 * @property dynamodbv2s
 * @property elasticsearch
 * @property enabled Specifies whether the rule is enabled.
 * @property errorAction Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
 * @property firehoses
 * @property https
 * @property iotAnalytics
 * @property iotEvents
 * @property kafkas
 * @property kineses
 * @property lambdas
 * @property name The name of the rule.
 * @property republishes
 * @property s3
 * @property sns
 * @property sql The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
 * @property sqlVersion The version of the SQL rules engine to use when evaluating the rule.
 * @property sqs
 * @property stepFunctions
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timestreams
 */
public data class TopicRuleArgs(
    public val cloudwatchAlarms: Output<List<TopicRuleCloudwatchAlarmArgs>>? = null,
    public val cloudwatchLogs: Output<List<TopicRuleCloudwatchLogArgs>>? = null,
    public val cloudwatchMetrics: Output<List<TopicRuleCloudwatchMetricArgs>>? = null,
    public val description: Output<String>? = null,
    public val dynamodbs: Output<List<TopicRuleDynamodbArgs>>? = null,
    public val dynamodbv2s: Output<List<TopicRuleDynamodbv2Args>>? = null,
    public val elasticsearch: Output<List<TopicRuleElasticsearchArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val errorAction: Output<TopicRuleErrorActionArgs>? = null,
    public val firehoses: Output<List<TopicRuleFirehoseArgs>>? = null,
    public val https: Output<List<TopicRuleHttpArgs>>? = null,
    public val iotAnalytics: Output<List<TopicRuleIotAnalyticArgs>>? = null,
    public val iotEvents: Output<List<TopicRuleIotEventArgs>>? = null,
    public val kafkas: Output<List<TopicRuleKafkaArgs>>? = null,
    public val kineses: Output<List<TopicRuleKinesisArgs>>? = null,
    public val lambdas: Output<List<TopicRuleLambdaArgs>>? = null,
    public val name: Output<String>? = null,
    public val republishes: Output<List<TopicRuleRepublishArgs>>? = null,
    public val s3: Output<List<TopicRuleS3Args>>? = null,
    public val sns: Output<List<TopicRuleSnsArgs>>? = null,
    public val sql: Output<String>? = null,
    public val sqlVersion: Output<String>? = null,
    public val sqs: Output<List<TopicRuleSqsArgs>>? = null,
    public val stepFunctions: Output<List<TopicRuleStepFunctionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timestreams: Output<List<TopicRuleTimestreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.TopicRuleArgs> {
    override fun toJava(): com.pulumi.aws.iot.TopicRuleArgs =
        com.pulumi.aws.iot.TopicRuleArgs.builder()
            .cloudwatchAlarms(
                cloudwatchAlarms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cloudwatchLogs(
                cloudwatchLogs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cloudwatchMetrics(
                cloudwatchMetrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .dynamodbs(
                dynamodbs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dynamodbv2s(
                dynamodbv2s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .elasticsearch(
                elasticsearch?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .errorAction(errorAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firehoses(
                firehoses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .https(https?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .iotAnalytics(
                iotAnalytics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .iotEvents(
                iotEvents?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .kafkas(kafkas?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .kineses(
                kineses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .lambdas(
                lambdas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .republishes(
                republishes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .s3(s3?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sns(sns?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sql(sql?.applyValue({ args0 -> args0 }))
            .sqlVersion(sqlVersion?.applyValue({ args0 -> args0 }))
            .sqs(sqs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .stepFunctions(
                stepFunctions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timestreams(
                timestreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TopicRuleArgs].
 */
@PulumiTagMarker
public class TopicRuleArgsBuilder internal constructor() {
    private var cloudwatchAlarms: Output<List<TopicRuleCloudwatchAlarmArgs>>? = null

    private var cloudwatchLogs: Output<List<TopicRuleCloudwatchLogArgs>>? = null

    private var cloudwatchMetrics: Output<List<TopicRuleCloudwatchMetricArgs>>? = null

    private var description: Output<String>? = null

    private var dynamodbs: Output<List<TopicRuleDynamodbArgs>>? = null

    private var dynamodbv2s: Output<List<TopicRuleDynamodbv2Args>>? = null

    private var elasticsearch: Output<List<TopicRuleElasticsearchArgs>>? = null

    private var enabled: Output<Boolean>? = null

    private var errorAction: Output<TopicRuleErrorActionArgs>? = null

    private var firehoses: Output<List<TopicRuleFirehoseArgs>>? = null

    private var https: Output<List<TopicRuleHttpArgs>>? = null

    private var iotAnalytics: Output<List<TopicRuleIotAnalyticArgs>>? = null

    private var iotEvents: Output<List<TopicRuleIotEventArgs>>? = null

    private var kafkas: Output<List<TopicRuleKafkaArgs>>? = null

    private var kineses: Output<List<TopicRuleKinesisArgs>>? = null

    private var lambdas: Output<List<TopicRuleLambdaArgs>>? = null

    private var name: Output<String>? = null

    private var republishes: Output<List<TopicRuleRepublishArgs>>? = null

    private var s3: Output<List<TopicRuleS3Args>>? = null

    private var sns: Output<List<TopicRuleSnsArgs>>? = null

    private var sql: Output<String>? = null

    private var sqlVersion: Output<String>? = null

    private var sqs: Output<List<TopicRuleSqsArgs>>? = null

    private var stepFunctions: Output<List<TopicRuleStepFunctionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timestreams: Output<List<TopicRuleTimestreamArgs>>? = null

    /**
     * @param value
     */
    @JvmName("kyjjjbvlwryxuhkp")
    public suspend fun cloudwatchAlarms(`value`: Output<List<TopicRuleCloudwatchAlarmArgs>>) {
        this.cloudwatchAlarms = value
    }

    @JvmName("jtwsnycuximhcfkm")
    public suspend fun cloudwatchAlarms(vararg values: Output<TopicRuleCloudwatchAlarmArgs>) {
        this.cloudwatchAlarms = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("oyauxbshjcfilndp")
    public suspend fun cloudwatchAlarms(values: List<Output<TopicRuleCloudwatchAlarmArgs>>) {
        this.cloudwatchAlarms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("vrjuxgnsygoeemln")
    public suspend fun cloudwatchLogs(`value`: Output<List<TopicRuleCloudwatchLogArgs>>) {
        this.cloudwatchLogs = value
    }

    @JvmName("nidmyxoxnacqnigc")
    public suspend fun cloudwatchLogs(vararg values: Output<TopicRuleCloudwatchLogArgs>) {
        this.cloudwatchLogs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("jibarqinfrujpafh")
    public suspend fun cloudwatchLogs(values: List<Output<TopicRuleCloudwatchLogArgs>>) {
        this.cloudwatchLogs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xmpuvqrxkckodxbq")
    public suspend fun cloudwatchMetrics(`value`: Output<List<TopicRuleCloudwatchMetricArgs>>) {
        this.cloudwatchMetrics = value
    }

    @JvmName("dyapcqvpdhaybcld")
    public suspend fun cloudwatchMetrics(vararg values: Output<TopicRuleCloudwatchMetricArgs>) {
        this.cloudwatchMetrics = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("aqcghjcdwwhfcsev")
    public suspend fun cloudwatchMetrics(values: List<Output<TopicRuleCloudwatchMetricArgs>>) {
        this.cloudwatchMetrics = Output.all(values)
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("xwfgkhtoldruvonm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("wnslcjdbyghsnfuw")
    public suspend fun dynamodbs(`value`: Output<List<TopicRuleDynamodbArgs>>) {
        this.dynamodbs = value
    }

    @JvmName("agupjlsmneovvsxl")
    public suspend fun dynamodbs(vararg values: Output<TopicRuleDynamodbArgs>) {
        this.dynamodbs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rdvcwqammxrhucms")
    public suspend fun dynamodbs(values: List<Output<TopicRuleDynamodbArgs>>) {
        this.dynamodbs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("sqkhchhyvgvryhkh")
    public suspend fun dynamodbv2s(`value`: Output<List<TopicRuleDynamodbv2Args>>) {
        this.dynamodbv2s = value
    }

    @JvmName("xwekmspsxpmssvha")
    public suspend fun dynamodbv2s(vararg values: Output<TopicRuleDynamodbv2Args>) {
        this.dynamodbv2s = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("bowfbmmsuuyulnny")
    public suspend fun dynamodbv2s(values: List<Output<TopicRuleDynamodbv2Args>>) {
        this.dynamodbv2s = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("scadbwuybmsuiyic")
    public suspend fun elasticsearch(`value`: Output<List<TopicRuleElasticsearchArgs>>) {
        this.elasticsearch = value
    }

    @JvmName("ypawtfjvhfahyuax")
    public suspend fun elasticsearch(vararg values: Output<TopicRuleElasticsearchArgs>) {
        this.elasticsearch = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("kfuwpootnoyfukvi")
    public suspend fun elasticsearch(values: List<Output<TopicRuleElasticsearchArgs>>) {
        this.elasticsearch = Output.all(values)
    }

    /**
     * @param value Specifies whether the rule is enabled.
     */
    @JvmName("svgfnuywdhoolfft")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
     */
    @JvmName("sartradgukulqndx")
    public suspend fun errorAction(`value`: Output<TopicRuleErrorActionArgs>) {
        this.errorAction = value
    }

    /**
     * @param value
     */
    @JvmName("tfvcfihodsdohvhj")
    public suspend fun firehoses(`value`: Output<List<TopicRuleFirehoseArgs>>) {
        this.firehoses = value
    }

    @JvmName("tlkjviwwprkkyubj")
    public suspend fun firehoses(vararg values: Output<TopicRuleFirehoseArgs>) {
        this.firehoses = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("dqqdepwayhtyywxo")
    public suspend fun firehoses(values: List<Output<TopicRuleFirehoseArgs>>) {
        this.firehoses = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("amntfpssdptxxfbw")
    public suspend fun https(`value`: Output<List<TopicRuleHttpArgs>>) {
        this.https = value
    }

    @JvmName("emnbcaetwqgxddrf")
    public suspend fun https(vararg values: Output<TopicRuleHttpArgs>) {
        this.https = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("bapnqltbxnnpeqva")
    public suspend fun https(values: List<Output<TopicRuleHttpArgs>>) {
        this.https = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("beiahljimauxovoo")
    public suspend fun iotAnalytics(`value`: Output<List<TopicRuleIotAnalyticArgs>>) {
        this.iotAnalytics = value
    }

    @JvmName("nmgvrnobmerboqhs")
    public suspend fun iotAnalytics(vararg values: Output<TopicRuleIotAnalyticArgs>) {
        this.iotAnalytics = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qvtfrviqsycscorn")
    public suspend fun iotAnalytics(values: List<Output<TopicRuleIotAnalyticArgs>>) {
        this.iotAnalytics = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("iyexvgjeuwgqskqk")
    public suspend fun iotEvents(`value`: Output<List<TopicRuleIotEventArgs>>) {
        this.iotEvents = value
    }

    @JvmName("jpkbcjpfvqpixuxt")
    public suspend fun iotEvents(vararg values: Output<TopicRuleIotEventArgs>) {
        this.iotEvents = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rfpcdtbwlrgijhxw")
    public suspend fun iotEvents(values: List<Output<TopicRuleIotEventArgs>>) {
        this.iotEvents = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fgnnootidbtngdaw")
    public suspend fun kafkas(`value`: Output<List<TopicRuleKafkaArgs>>) {
        this.kafkas = value
    }

    @JvmName("eartbeivlgsjvkyc")
    public suspend fun kafkas(vararg values: Output<TopicRuleKafkaArgs>) {
        this.kafkas = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("dutrliruesbrrxqr")
    public suspend fun kafkas(values: List<Output<TopicRuleKafkaArgs>>) {
        this.kafkas = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ojdtvqixtxqgpmpo")
    public suspend fun kineses(`value`: Output<List<TopicRuleKinesisArgs>>) {
        this.kineses = value
    }

    @JvmName("xydrycohaoqqohaa")
    public suspend fun kineses(vararg values: Output<TopicRuleKinesisArgs>) {
        this.kineses = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("thbenecxwbickldi")
    public suspend fun kineses(values: List<Output<TopicRuleKinesisArgs>>) {
        this.kineses = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gkgckimegurdqwna")
    public suspend fun lambdas(`value`: Output<List<TopicRuleLambdaArgs>>) {
        this.lambdas = value
    }

    @JvmName("umbycfikomaypbnp")
    public suspend fun lambdas(vararg values: Output<TopicRuleLambdaArgs>) {
        this.lambdas = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("aemarrgyaxvyioaw")
    public suspend fun lambdas(values: List<Output<TopicRuleLambdaArgs>>) {
        this.lambdas = Output.all(values)
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("uulicdqcyttlecfs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("clfxphsknfgfafkp")
    public suspend fun republishes(`value`: Output<List<TopicRuleRepublishArgs>>) {
        this.republishes = value
    }

    @JvmName("xxvqreukuhnnbypg")
    public suspend fun republishes(vararg values: Output<TopicRuleRepublishArgs>) {
        this.republishes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nwglfgugltuqpqny")
    public suspend fun republishes(values: List<Output<TopicRuleRepublishArgs>>) {
        this.republishes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("yvamoquxdcsrshat")
    public suspend fun s3(`value`: Output<List<TopicRuleS3Args>>) {
        this.s3 = value
    }

    @JvmName("yxikeuseoqdnyuhk")
    public suspend fun s3(vararg values: Output<TopicRuleS3Args>) {
        this.s3 = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fsugtwrmysixhacw")
    public suspend fun s3(values: List<Output<TopicRuleS3Args>>) {
        this.s3 = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hpeapljonxjtlukq")
    public suspend fun sns(`value`: Output<List<TopicRuleSnsArgs>>) {
        this.sns = value
    }

    @JvmName("qdtxseugueklemtt")
    public suspend fun sns(vararg values: Output<TopicRuleSnsArgs>) {
        this.sns = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("hxcvnhgmibenjoqf")
    public suspend fun sns(values: List<Output<TopicRuleSnsArgs>>) {
        this.sns = Output.all(values)
    }

    /**
     * @param value The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
     */
    @JvmName("qatnpeuhkvtulqlm")
    public suspend fun sql(`value`: Output<String>) {
        this.sql = value
    }

    /**
     * @param value The version of the SQL rules engine to use when evaluating the rule.
     */
    @JvmName("nhvxpuhskonymhiu")
    public suspend fun sqlVersion(`value`: Output<String>) {
        this.sqlVersion = value
    }

    /**
     * @param value
     */
    @JvmName("ewtlhfjtuxcrvnof")
    public suspend fun sqs(`value`: Output<List<TopicRuleSqsArgs>>) {
        this.sqs = value
    }

    @JvmName("yqvmenrrppxyudah")
    public suspend fun sqs(vararg values: Output<TopicRuleSqsArgs>) {
        this.sqs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("hyfffnxjsnydmawf")
    public suspend fun sqs(values: List<Output<TopicRuleSqsArgs>>) {
        this.sqs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kqbwkegimtiqffgu")
    public suspend fun stepFunctions(`value`: Output<List<TopicRuleStepFunctionArgs>>) {
        this.stepFunctions = value
    }

    @JvmName("vvaymxkenhuwsouj")
    public suspend fun stepFunctions(vararg values: Output<TopicRuleStepFunctionArgs>) {
        this.stepFunctions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("lqbxudoqxosacdys")
    public suspend fun stepFunctions(values: List<Output<TopicRuleStepFunctionArgs>>) {
        this.stepFunctions = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ppxnsbgfpagvrohi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("iiigsvqsosgekism")
    public suspend fun timestreams(`value`: Output<List<TopicRuleTimestreamArgs>>) {
        this.timestreams = value
    }

    @JvmName("bvqcnajnmupvpjrp")
    public suspend fun timestreams(vararg values: Output<TopicRuleTimestreamArgs>) {
        this.timestreams = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nlkcqyocdfdabwcq")
    public suspend fun timestreams(values: List<Output<TopicRuleTimestreamArgs>>) {
        this.timestreams = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("bcjinitulcfolgny")
    public suspend fun cloudwatchAlarms(`value`: List<TopicRuleCloudwatchAlarmArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tqfwiaaloshcmbof")
    public suspend
    fun cloudwatchAlarms(argument: List<suspend TopicRuleCloudwatchAlarmArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchAlarmArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yjrsrxwbsgseydgk")
    public suspend fun cloudwatchAlarms(
        vararg
        argument: suspend TopicRuleCloudwatchAlarmArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchAlarmArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rhvumgwbonptlcor")
    public suspend
    fun cloudwatchAlarms(argument: suspend TopicRuleCloudwatchAlarmArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TopicRuleCloudwatchAlarmArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param values
     */
    @JvmName("rwajpjkfvmauebby")
    public suspend fun cloudwatchAlarms(vararg values: TopicRuleCloudwatchAlarmArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param value
     */
    @JvmName("viokbwhlasubnadd")
    public suspend fun cloudwatchLogs(`value`: List<TopicRuleCloudwatchLogArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("peqduxqnhoitmgqr")
    public suspend
    fun cloudwatchLogs(argument: List<suspend TopicRuleCloudwatchLogArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchLogArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ejymonabqvtrefhl")
    public suspend fun cloudwatchLogs(
        vararg
        argument: suspend TopicRuleCloudwatchLogArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchLogArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("afwgknwugitolbbj")
    public suspend
    fun cloudwatchLogs(argument: suspend TopicRuleCloudwatchLogArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleCloudwatchLogArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param values
     */
    @JvmName("aywyxcpnhlfvhirl")
    public suspend fun cloudwatchLogs(vararg values: TopicRuleCloudwatchLogArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value
     */
    @JvmName("vkwindroalpdttti")
    public suspend fun cloudwatchMetrics(`value`: List<TopicRuleCloudwatchMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uxhxqosyectncprb")
    public suspend
    fun cloudwatchMetrics(argument: List<suspend TopicRuleCloudwatchMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rchybmrinambymbl")
    public suspend fun cloudwatchMetrics(
        vararg
        argument: suspend TopicRuleCloudwatchMetricArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("exxfqeysoeeuqvop")
    public suspend
    fun cloudwatchMetrics(argument: suspend TopicRuleCloudwatchMetricArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TopicRuleCloudwatchMetricArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param values
     */
    @JvmName("ftkvnrqoqyotxdra")
    public suspend fun cloudwatchMetrics(vararg values: TopicRuleCloudwatchMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("qtpgwltfvipelyhx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("crykrirklctwbqvj")
    public suspend fun dynamodbs(`value`: List<TopicRuleDynamodbArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gmuactdrwapuktje")
    public suspend fun dynamodbs(argument: List<suspend TopicRuleDynamodbArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleDynamodbArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mcrbaltsusfiroma")
    public suspend fun dynamodbs(vararg argument: suspend TopicRuleDynamodbArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleDynamodbArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pmxmorvdysbrvrsv")
    public suspend fun dynamodbs(argument: suspend TopicRuleDynamodbArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleDynamodbArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dynamodbs = mapped
    }

    /**
     * @param values
     */
    @JvmName("tttbvwcwwckcsndr")
    public suspend fun dynamodbs(vararg values: TopicRuleDynamodbArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamodbs = mapped
    }

    /**
     * @param value
     */
    @JvmName("pgwtpmbwfslsyrbu")
    public suspend fun dynamodbv2s(`value`: List<TopicRuleDynamodbv2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbv2s = mapped
    }

    /**
     * @param argument
     */
    @JvmName("itvrgbrfuvkyvvkj")
    public suspend
    fun dynamodbv2s(argument: List<suspend TopicRuleDynamodbv2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleDynamodbv2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbv2s = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hokagkselvnoesks")
    public suspend fun dynamodbv2s(
        vararg
        argument: suspend TopicRuleDynamodbv2ArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleDynamodbv2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbv2s = mapped
    }

    /**
     * @param argument
     */
    @JvmName("itmppvusrvwvfdcn")
    public suspend fun dynamodbv2s(argument: suspend TopicRuleDynamodbv2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleDynamodbv2ArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dynamodbv2s = mapped
    }

    /**
     * @param values
     */
    @JvmName("gfumifgypiovuajv")
    public suspend fun dynamodbv2s(vararg values: TopicRuleDynamodbv2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamodbv2s = mapped
    }

    /**
     * @param value
     */
    @JvmName("wrlfgksppuiacmfo")
    public suspend fun elasticsearch(`value`: List<TopicRuleElasticsearchArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearch = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ptfmgkcmbsimgypf")
    public suspend
    fun elasticsearch(argument: List<suspend TopicRuleElasticsearchArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleElasticsearchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.elasticsearch = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wnpnnjobynibakpf")
    public suspend fun elasticsearch(
        vararg
        argument: suspend TopicRuleElasticsearchArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleElasticsearchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.elasticsearch = mapped
    }

    /**
     * @param argument
     */
    @JvmName("chxoftqpeftjtatm")
    public suspend fun elasticsearch(argument: suspend TopicRuleElasticsearchArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleElasticsearchArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.elasticsearch = mapped
    }

    /**
     * @param values
     */
    @JvmName("rncthxdpanfjtfmq")
    public suspend fun elasticsearch(vararg values: TopicRuleElasticsearchArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.elasticsearch = mapped
    }

    /**
     * @param value Specifies whether the rule is enabled.
     */
    @JvmName("brtnounemfxklcer")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
     */
    @JvmName("ffjadpatwydlktqw")
    public suspend fun errorAction(`value`: TopicRuleErrorActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorAction = mapped
    }

    /**
     * @param argument Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
     */
    @JvmName("ufwgtttuwytsiksw")
    public suspend fun errorAction(argument: suspend TopicRuleErrorActionArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.errorAction = mapped
    }

    /**
     * @param value
     */
    @JvmName("ieyfuwbycwhhdjya")
    public suspend fun firehoses(`value`: List<TopicRuleFirehoseArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehoses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ojhhtuggdutquapb")
    public suspend fun firehoses(argument: List<suspend TopicRuleFirehoseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleFirehoseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.firehoses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("etiyakubtwgpdqag")
    public suspend fun firehoses(vararg argument: suspend TopicRuleFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleFirehoseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.firehoses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jvetoplhsihbmbdq")
    public suspend fun firehoses(argument: suspend TopicRuleFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleFirehoseArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.firehoses = mapped
    }

    /**
     * @param values
     */
    @JvmName("efrjgggmigyefkpi")
    public suspend fun firehoses(vararg values: TopicRuleFirehoseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firehoses = mapped
    }

    /**
     * @param value
     */
    @JvmName("cmouwfhjevxgccsy")
    public suspend fun https(`value`: List<TopicRuleHttpArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.https = mapped
    }

    /**
     * @param argument
     */
    @JvmName("waqbewghojbkckyv")
    public suspend fun https(argument: List<suspend TopicRuleHttpArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleHttpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eobwatqfqpeujror")
    public suspend fun https(vararg argument: suspend TopicRuleHttpArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleHttpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dmdntcwrydexyjmk")
    public suspend fun https(argument: suspend TopicRuleHttpArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleHttpArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param values
     */
    @JvmName("pbcwourdqchecquf")
    public suspend fun https(vararg values: TopicRuleHttpArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.https = mapped
    }

    /**
     * @param value
     */
    @JvmName("dgyagonnwuucseje")
    public suspend fun iotAnalytics(`value`: List<TopicRuleIotAnalyticArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotAnalytics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uabusaumnmmtgskm")
    public suspend
    fun iotAnalytics(argument: List<suspend TopicRuleIotAnalyticArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleIotAnalyticArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotAnalytics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qkwkxcuwdlpwkjys")
    public suspend fun iotAnalytics(
        vararg
        argument: suspend TopicRuleIotAnalyticArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleIotAnalyticArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotAnalytics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ilnulpylkxwqffqy")
    public suspend fun iotAnalytics(argument: suspend TopicRuleIotAnalyticArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleIotAnalyticArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.iotAnalytics = mapped
    }

    /**
     * @param values
     */
    @JvmName("bhbvlqevkkcikkhn")
    public suspend fun iotAnalytics(vararg values: TopicRuleIotAnalyticArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iotAnalytics = mapped
    }

    /**
     * @param value
     */
    @JvmName("wlvsflfopxnqaydf")
    public suspend fun iotEvents(`value`: List<TopicRuleIotEventArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotEvents = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mjwtdoigesgmnspr")
    public suspend fun iotEvents(argument: List<suspend TopicRuleIotEventArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleIotEventArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotEvents = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gilfbfwcyddvssqt")
    public suspend fun iotEvents(vararg argument: suspend TopicRuleIotEventArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleIotEventArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotEvents = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qeadwcrxvpsbrtlo")
    public suspend fun iotEvents(argument: suspend TopicRuleIotEventArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleIotEventArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.iotEvents = mapped
    }

    /**
     * @param values
     */
    @JvmName("pkqersdggdkowfjr")
    public suspend fun iotEvents(vararg values: TopicRuleIotEventArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iotEvents = mapped
    }

    /**
     * @param value
     */
    @JvmName("qhowhrbetywrduyi")
    public suspend fun kafkas(`value`: List<TopicRuleKafkaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nwxxboflguulwrwu")
    public suspend fun kafkas(argument: List<suspend TopicRuleKafkaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleKafkaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ragobduiyfvpivkw")
    public suspend fun kafkas(vararg argument: suspend TopicRuleKafkaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleKafkaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mvyrjwxqmiflimyn")
    public suspend fun kafkas(argument: suspend TopicRuleKafkaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleKafkaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.kafkas = mapped
    }

    /**
     * @param values
     */
    @JvmName("vrwnnwcfmpidedmm")
    public suspend fun kafkas(vararg values: TopicRuleKafkaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkas = mapped
    }

    /**
     * @param value
     */
    @JvmName("fjmnbkpivmxsuxmq")
    public suspend fun kineses(`value`: List<TopicRuleKinesisArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kineses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xfabqsdhhrkrvknd")
    public suspend fun kineses(argument: List<suspend TopicRuleKinesisArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleKinesisArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kineses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ibthncddlsrcnvff")
    public suspend fun kineses(vararg argument: suspend TopicRuleKinesisArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleKinesisArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kineses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cwhfvxxeevgvdudh")
    public suspend fun kineses(argument: suspend TopicRuleKinesisArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleKinesisArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.kineses = mapped
    }

    /**
     * @param values
     */
    @JvmName("weixxwydgsmcivdv")
    public suspend fun kineses(vararg values: TopicRuleKinesisArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kineses = mapped
    }

    /**
     * @param value
     */
    @JvmName("suubovqhldpxithw")
    public suspend fun lambdas(`value`: List<TopicRuleLambdaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("elevuikrcoflsesf")
    public suspend fun lambdas(argument: List<suspend TopicRuleLambdaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleLambdaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lhsydaowbuwdoaaq")
    public suspend fun lambdas(vararg argument: suspend TopicRuleLambdaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleLambdaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gwkgaesodcmbplgj")
    public suspend fun lambdas(argument: suspend TopicRuleLambdaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleLambdaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lambdas = mapped
    }

    /**
     * @param values
     */
    @JvmName("rikdcnuutrtmsjjr")
    public suspend fun lambdas(vararg values: TopicRuleLambdaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdas = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("ubcjnshhnefgffgi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("ovpgldpqehkjxnji")
    public suspend fun republishes(`value`: List<TopicRuleRepublishArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.republishes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xgdkpcjwawjykycr")
    public suspend fun republishes(argument: List<suspend TopicRuleRepublishArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleRepublishArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.republishes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("amckmpikrhojnyos")
    public suspend fun republishes(
        vararg
        argument: suspend TopicRuleRepublishArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleRepublishArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.republishes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("molmreivkgvstjti")
    public suspend fun republishes(argument: suspend TopicRuleRepublishArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleRepublishArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.republishes = mapped
    }

    /**
     * @param values
     */
    @JvmName("vmpgghmfnlmeccwi")
    public suspend fun republishes(vararg values: TopicRuleRepublishArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.republishes = mapped
    }

    /**
     * @param value
     */
    @JvmName("veecsdvrqwqnesxp")
    public suspend fun s3(`value`: List<TopicRuleS3Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uiaslfmodriugfhl")
    public suspend fun s3(argument: List<suspend TopicRuleS3ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TopicRuleS3ArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wspsxpqehngmberm")
    public suspend fun s3(vararg argument: suspend TopicRuleS3ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TopicRuleS3ArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sbubsmqirlqmeduj")
    public suspend fun s3(argument: suspend TopicRuleS3ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleS3ArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param values
     */
    @JvmName("hyhcghcgwawiklxe")
    public suspend fun s3(vararg values: TopicRuleS3Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param value
     */
    @JvmName("pwsidefdfssthcsg")
    public suspend fun sns(`value`: List<TopicRuleSnsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sns = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kqxktgfkkayyfaoi")
    public suspend fun sns(argument: List<suspend TopicRuleSnsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleSnsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sns = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xidrolkcsarcpkuf")
    public suspend fun sns(vararg argument: suspend TopicRuleSnsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleSnsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sns = mapped
    }

    /**
     * @param argument
     */
    @JvmName("llaqfgpjacksgycy")
    public suspend fun sns(argument: suspend TopicRuleSnsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleSnsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sns = mapped
    }

    /**
     * @param values
     */
    @JvmName("usamovsqvvyyalbt")
    public suspend fun sns(vararg values: TopicRuleSnsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sns = mapped
    }

    /**
     * @param value The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
     */
    @JvmName("bmneagrbicghdrsv")
    public suspend fun sql(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sql = mapped
    }

    /**
     * @param value The version of the SQL rules engine to use when evaluating the rule.
     */
    @JvmName("tuqlomtidmdfxwne")
    public suspend fun sqlVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("nfbwaakncrivjtso")
    public suspend fun sqs(`value`: List<TopicRuleSqsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xvysvhwhswbjwkvi")
    public suspend fun sqs(argument: List<suspend TopicRuleSqsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleSqsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sqs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("frjfyhdxmoxpsoew")
    public suspend fun sqs(vararg argument: suspend TopicRuleSqsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleSqsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sqs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ktwrimulpvwwxgro")
    public suspend fun sqs(argument: suspend TopicRuleSqsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleSqsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sqs = mapped
    }

    /**
     * @param values
     */
    @JvmName("ghapukvwcptwsfrf")
    public suspend fun sqs(vararg values: TopicRuleSqsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqs = mapped
    }

    /**
     * @param value
     */
    @JvmName("rqldyxijobqonwtx")
    public suspend fun stepFunctions(`value`: List<TopicRuleStepFunctionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepFunctions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qqfqksvarwihhoqq")
    public suspend
    fun stepFunctions(argument: List<suspend TopicRuleStepFunctionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleStepFunctionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stepFunctions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("daqqiqroesmxinjv")
    public suspend fun stepFunctions(
        vararg
        argument: suspend TopicRuleStepFunctionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleStepFunctionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stepFunctions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mswkhachduapimke")
    public suspend fun stepFunctions(argument: suspend TopicRuleStepFunctionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleStepFunctionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.stepFunctions = mapped
    }

    /**
     * @param values
     */
    @JvmName("qhiifdkupcflsniv")
    public suspend fun stepFunctions(vararg values: TopicRuleStepFunctionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stepFunctions = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bauxjrynyxuhdjbc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ccefbefmvqqvsomj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("ifiiasdigpxcgiaw")
    public suspend fun timestreams(`value`: List<TopicRuleTimestreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jiocaqxelqtnkqxu")
    public suspend
    fun timestreams(argument: List<suspend TopicRuleTimestreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleTimestreamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timestreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qssqrgoawoseysqu")
    public suspend fun timestreams(
        vararg
        argument: suspend TopicRuleTimestreamArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleTimestreamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timestreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("flhqssrvakyjadhj")
    public suspend fun timestreams(argument: suspend TopicRuleTimestreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleTimestreamArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.timestreams = mapped
    }

    /**
     * @param values
     */
    @JvmName("ofquvfukfvwcjkas")
    public suspend fun timestreams(vararg values: TopicRuleTimestreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timestreams = mapped
    }

    internal fun build(): TopicRuleArgs = TopicRuleArgs(
        cloudwatchAlarms = cloudwatchAlarms,
        cloudwatchLogs = cloudwatchLogs,
        cloudwatchMetrics = cloudwatchMetrics,
        description = description,
        dynamodbs = dynamodbs,
        dynamodbv2s = dynamodbv2s,
        elasticsearch = elasticsearch,
        enabled = enabled,
        errorAction = errorAction,
        firehoses = firehoses,
        https = https,
        iotAnalytics = iotAnalytics,
        iotEvents = iotEvents,
        kafkas = kafkas,
        kineses = kineses,
        lambdas = lambdas,
        name = name,
        republishes = republishes,
        s3 = s3,
        sns = sns,
        sql = sql,
        sqlVersion = sqlVersion,
        sqs = sqs,
        stepFunctions = stepFunctions,
        tags = tags,
        timestreams = timestreams,
    )
}
