@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.TopicRuleDestinationVpcConfiguration
import com.pulumi.aws.iot.kotlin.outputs.TopicRuleDestinationVpcConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TopicRuleDestination].
 */
@PulumiTagMarker
public class TopicRuleDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TopicRuleDestinationArgs = TopicRuleDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TopicRuleDestinationArgsBuilder.() -> Unit) {
        val builder = TopicRuleDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TopicRuleDestination {
        val builtJavaResource = com.pulumi.aws.iot.TopicRuleDestination(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TopicRuleDestination(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Using `pulumi import`, import IoT topic rule destinations using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:iot/topicRuleDestination:TopicRuleDestination example arn:aws:iot:us-west-2:123456789012:ruledestination/vpc/2ce781c8-68a6-4c52-9c62-63fe489ecc60
 * ```
 *
 */
public class TopicRuleDestination internal constructor(
    override val javaResource: com.pulumi.aws.iot.TopicRuleDestination,
) : KotlinCustomResource(javaResource, TopicRuleDestinationMapper) {
    /**
     * The ARN of the topic rule destination
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether or not to enable the destination. Default: `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration of the virtual private cloud (VPC) connection. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/vpc-rule-action.html).
     */
    public val vpcConfiguration: Output<TopicRuleDestinationVpcConfiguration>
        get() = javaResource.vpcConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object TopicRuleDestinationMapper : ResourceMapper<TopicRuleDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.TopicRuleDestination::class == javaResource::class

    override fun map(javaResource: Resource): TopicRuleDestination = TopicRuleDestination(
        javaResource
            as com.pulumi.aws.iot.TopicRuleDestination,
    )
}

/**
 * @see [TopicRuleDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TopicRuleDestination].
 */
public suspend fun topicRuleDestination(
    name: String,
    block: suspend TopicRuleDestinationResourceBuilder.() -> Unit,
): TopicRuleDestination {
    val builder = TopicRuleDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TopicRuleDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun topicRuleDestination(name: String): TopicRuleDestination {
    val builder = TopicRuleDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
