@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.TopicRuleDestinationArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDestinationVpcConfigurationArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDestinationVpcConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Using `pulumi import`, import IoT topic rule destinations using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:iot/topicRuleDestination:TopicRuleDestination example arn:aws:iot:us-west-2:123456789012:ruledestination/vpc/2ce781c8-68a6-4c52-9c62-63fe489ecc60
 * ```
 * @property enabled Whether or not to enable the destination. Default: `true`.
 * @property vpcConfiguration Configuration of the virtual private cloud (VPC) connection. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/vpc-rule-action.html).
 */
public data class TopicRuleDestinationArgs(
    public val enabled: Output<Boolean>? = null,
    public val vpcConfiguration: Output<TopicRuleDestinationVpcConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.TopicRuleDestinationArgs> {
    override fun toJava(): com.pulumi.aws.iot.TopicRuleDestinationArgs =
        com.pulumi.aws.iot.TopicRuleDestinationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .vpcConfiguration(
                vpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TopicRuleDestinationArgs].
 */
@PulumiTagMarker
public class TopicRuleDestinationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var vpcConfiguration: Output<TopicRuleDestinationVpcConfigurationArgs>? = null

    /**
     * @param value Whether or not to enable the destination. Default: `true`.
     */
    @JvmName("nbwtbcnrjnvgvwkn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Configuration of the virtual private cloud (VPC) connection. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/vpc-rule-action.html).
     */
    @JvmName("ytlirvdnmuvsprmu")
    public suspend fun vpcConfiguration(`value`: Output<TopicRuleDestinationVpcConfigurationArgs>) {
        this.vpcConfiguration = value
    }

    /**
     * @param value Whether or not to enable the destination. Default: `true`.
     */
    @JvmName("faikhtpnxrluqwxg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Configuration of the virtual private cloud (VPC) connection. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/vpc-rule-action.html).
     */
    @JvmName("yygiryqmhugcywgf")
    public suspend fun vpcConfiguration(`value`: TopicRuleDestinationVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfiguration = mapped
    }

    /**
     * @param argument Configuration of the virtual private cloud (VPC) connection. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/vpc-rule-action.html).
     */
    @JvmName("hayrmrpqjjlexbmq")
    public suspend
    fun vpcConfiguration(argument: suspend TopicRuleDestinationVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleDestinationVpcConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vpcConfiguration = mapped
    }

    internal fun build(): TopicRuleDestinationArgs = TopicRuleDestinationArgs(
        enabled = enabled,
        vpcConfiguration = vpcConfiguration,
    )
}
