@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.DomainConfigurationAuthorizerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allowAuthorizerOverride A Boolean that specifies whether the domain configuration's authorization service can be overridden.
 * @property defaultAuthorizerName The name of the authorization service for a domain configuration.
 */
public data class DomainConfigurationAuthorizerConfigArgs(
    public val allowAuthorizerOverride: Output<Boolean>? = null,
    public val defaultAuthorizerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.DomainConfigurationAuthorizerConfigArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.DomainConfigurationAuthorizerConfigArgs =
        com.pulumi.aws.iot.inputs.DomainConfigurationAuthorizerConfigArgs.builder()
            .allowAuthorizerOverride(allowAuthorizerOverride?.applyValue({ args0 -> args0 }))
            .defaultAuthorizerName(defaultAuthorizerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainConfigurationAuthorizerConfigArgs].
 */
@PulumiTagMarker
public class DomainConfigurationAuthorizerConfigArgsBuilder internal constructor() {
    private var allowAuthorizerOverride: Output<Boolean>? = null

    private var defaultAuthorizerName: Output<String>? = null

    /**
     * @param value A Boolean that specifies whether the domain configuration's authorization service can be overridden.
     */
    @JvmName("jrgjeotydoghpnup")
    public suspend fun allowAuthorizerOverride(`value`: Output<Boolean>) {
        this.allowAuthorizerOverride = value
    }

    /**
     * @param value The name of the authorization service for a domain configuration.
     */
    @JvmName("gixxppishmnxprpy")
    public suspend fun defaultAuthorizerName(`value`: Output<String>) {
        this.defaultAuthorizerName = value
    }

    /**
     * @param value A Boolean that specifies whether the domain configuration's authorization service can be overridden.
     */
    @JvmName("ybkohmluapulwbkc")
    public suspend fun allowAuthorizerOverride(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowAuthorizerOverride = mapped
    }

    /**
     * @param value The name of the authorization service for a domain configuration.
     */
    @JvmName("bgupesskimwupufl")
    public suspend fun defaultAuthorizerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAuthorizerName = mapped
    }

    internal fun build(): DomainConfigurationAuthorizerConfigArgs =
        DomainConfigurationAuthorizerConfigArgs(
            allowAuthorizerOverride = allowAuthorizerOverride,
            defaultAuthorizerName = defaultAuthorizerName,
        )
}
