@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.DomainConfigurationTlsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property securityPolicy The security policy for a domain configuration.
 */
public data class DomainConfigurationTlsConfigArgs(
    public val securityPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.DomainConfigurationTlsConfigArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.DomainConfigurationTlsConfigArgs =
        com.pulumi.aws.iot.inputs.DomainConfigurationTlsConfigArgs.builder()
            .securityPolicy(securityPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainConfigurationTlsConfigArgs].
 */
@PulumiTagMarker
public class DomainConfigurationTlsConfigArgsBuilder internal constructor() {
    private var securityPolicy: Output<String>? = null

    /**
     * @param value The security policy for a domain configuration.
     */
    @JvmName("werqhfwukjkqshfa")
    public suspend fun securityPolicy(`value`: Output<String>) {
        this.securityPolicy = value
    }

    /**
     * @param value The security policy for a domain configuration.
     */
    @JvmName("fshiviehwnoltmeq")
    public suspend fun securityPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicy = mapped
    }

    internal fun build(): DomainConfigurationTlsConfigArgs = DomainConfigurationTlsConfigArgs(
        securityPolicy = securityPolicy,
    )
}
