@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.IndexingConfigurationThingGroupIndexingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customFields A list of thing group fields to index. This list cannot contain any managed fields. See below.
 * @property managedFields Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
 * @property thingGroupIndexingMode Thing group indexing mode. Valid values: `OFF`, `ON`.
 */
public data class IndexingConfigurationThingGroupIndexingConfigurationArgs(
    public val customFields:
    Output<List<IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgs>>? = null,
    public val managedFields:
    Output<List<IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgs>>? = null,
    public val thingGroupIndexingMode: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.iot.inputs.IndexingConfigurationThingGroupIndexingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.iot.inputs.IndexingConfigurationThingGroupIndexingConfigurationArgs =
        com.pulumi.aws.iot.inputs.IndexingConfigurationThingGroupIndexingConfigurationArgs.builder()
            .customFields(
                customFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .managedFields(
                managedFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .thingGroupIndexingMode(thingGroupIndexingMode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexingConfigurationThingGroupIndexingConfigurationArgs].
 */
@PulumiTagMarker
public class IndexingConfigurationThingGroupIndexingConfigurationArgsBuilder internal constructor() {
    private var customFields:
        Output<List<IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgs>>? = null

    private var managedFields:
        Output<List<IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgs>>? = null

    private var thingGroupIndexingMode: Output<String>? = null

    /**
     * @param value A list of thing group fields to index. This list cannot contain any managed fields. See below.
     */
    @JvmName("aepokvhpymcbbjab")
    public suspend
    fun customFields(`value`: Output<List<IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgs>>) {
        this.customFields = value
    }

    @JvmName("yyiyqofdoonhyuyw")
    public suspend fun customFields(
        vararg
        values: Output<IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgs>,
    ) {
        this.customFields = Output.all(values.asList())
    }

    /**
     * @param values A list of thing group fields to index. This list cannot contain any managed fields. See below.
     */
    @JvmName("hrhyfsvamunrcjpk")
    public suspend
    fun customFields(values: List<Output<IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgs>>) {
        this.customFields = Output.all(values)
    }

    /**
     * @param value Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("htbqqbokdudntqsn")
    public suspend
    fun managedFields(`value`: Output<List<IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgs>>) {
        this.managedFields = value
    }

    @JvmName("ilktscbufrqagfjg")
    public suspend fun managedFields(
        vararg
        values: Output<IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgs>,
    ) {
        this.managedFields = Output.all(values.asList())
    }

    /**
     * @param values Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("peosweeegrbxcftm")
    public suspend
    fun managedFields(values: List<Output<IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgs>>) {
        this.managedFields = Output.all(values)
    }

    /**
     * @param value Thing group indexing mode. Valid values: `OFF`, `ON`.
     */
    @JvmName("xivchwvgsbgidygg")
    public suspend fun thingGroupIndexingMode(`value`: Output<String>) {
        this.thingGroupIndexingMode = value
    }

    /**
     * @param value A list of thing group fields to index. This list cannot contain any managed fields. See below.
     */
    @JvmName("peqqyokjroegifly")
    public suspend
    fun customFields(`value`: List<IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customFields = mapped
    }

    /**
     * @param argument A list of thing group fields to index. This list cannot contain any managed fields. See below.
     */
    @JvmName("rfjuftqekhyccrrn")
    public suspend
    fun customFields(argument: List<suspend IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customFields = mapped
    }

    /**
     * @param argument A list of thing group fields to index. This list cannot contain any managed fields. See below.
     */
    @JvmName("vcsvymcijnomtebo")
    public suspend fun customFields(
        vararg
        argument: suspend IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customFields = mapped
    }

    /**
     * @param argument A list of thing group fields to index. This list cannot contain any managed fields. See below.
     */
    @JvmName("omadwmqkwntubucj")
    public suspend
    fun customFields(argument: suspend IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.customFields = mapped
    }

    /**
     * @param values A list of thing group fields to index. This list cannot contain any managed fields. See below.
     */
    @JvmName("judwikixpppfnaby")
    public suspend fun customFields(
        vararg
        values: IndexingConfigurationThingGroupIndexingConfigurationCustomFieldArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customFields = mapped
    }

    /**
     * @param value Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("nlygusjovccsfpcj")
    public suspend
    fun managedFields(`value`: List<IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedFields = mapped
    }

    /**
     * @param argument Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("aqbjclepvfwfgwws")
    public suspend
    fun managedFields(argument: List<suspend IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedFields = mapped
    }

    /**
     * @param argument Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("crlwfmhhtacbmicg")
    public suspend fun managedFields(
        vararg
        argument: suspend IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedFields = mapped
    }

    /**
     * @param argument Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("qusbvvanmypimvhi")
    public suspend
    fun managedFields(argument: suspend IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.managedFields = mapped
    }

    /**
     * @param values Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("gdvtjbflrgyttyli")
    public suspend fun managedFields(
        vararg
        values: IndexingConfigurationThingGroupIndexingConfigurationManagedFieldArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedFields = mapped
    }

    /**
     * @param value Thing group indexing mode. Valid values: `OFF`, `ON`.
     */
    @JvmName("gfmxdkfpdbrjmepx")
    public suspend fun thingGroupIndexingMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thingGroupIndexingMode = mapped
    }

    internal fun build(): IndexingConfigurationThingGroupIndexingConfigurationArgs =
        IndexingConfigurationThingGroupIndexingConfigurationArgs(
            customFields = customFields,
            managedFields = managedFields,
            thingGroupIndexingMode = thingGroupIndexingMode ?: throw
                PulumiNullFieldException("thingGroupIndexingMode"),
        )
}
