@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customFields Contains custom field names and their data type. See below.
 * @property deviceDefenderIndexingMode Device Defender indexing mode. Valid values: `VIOLATIONS`, `OFF`. Default: `OFF`.
 * @property filter Required if `named_shadow_indexing_mode` is `ON`. Enables to add named shadows filtered by `filter` to fleet indexing configuration.
 * @property managedFields Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
 * @property namedShadowIndexingMode [Named shadow](https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html) indexing mode. Valid values: `ON`, `OFF`. Default: `OFF`.
 * @property thingConnectivityIndexingMode Thing connectivity indexing mode. Valid values: `STATUS`, `OFF`. Default: `OFF`.
 * @property thingIndexingMode Thing indexing mode. Valid values: `REGISTRY`, `REGISTRY_AND_SHADOW`, `OFF`.
 */
public data class IndexingConfigurationThingIndexingConfigurationArgs(
    public val customFields:
    Output<List<IndexingConfigurationThingIndexingConfigurationCustomFieldArgs>>? = null,
    public val deviceDefenderIndexingMode: Output<String>? = null,
    public val filter: Output<IndexingConfigurationThingIndexingConfigurationFilterArgs>? = null,
    public val managedFields:
    Output<List<IndexingConfigurationThingIndexingConfigurationManagedFieldArgs>>? = null,
    public val namedShadowIndexingMode: Output<String>? = null,
    public val thingConnectivityIndexingMode: Output<String>? = null,
    public val thingIndexingMode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationArgs =
        com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationArgs.builder()
            .customFields(
                customFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deviceDefenderIndexingMode(deviceDefenderIndexingMode?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managedFields(
                managedFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .namedShadowIndexingMode(namedShadowIndexingMode?.applyValue({ args0 -> args0 }))
            .thingConnectivityIndexingMode(thingConnectivityIndexingMode?.applyValue({ args0 -> args0 }))
            .thingIndexingMode(thingIndexingMode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexingConfigurationThingIndexingConfigurationArgs].
 */
@PulumiTagMarker
public class IndexingConfigurationThingIndexingConfigurationArgsBuilder internal constructor() {
    private var customFields:
        Output<List<IndexingConfigurationThingIndexingConfigurationCustomFieldArgs>>? = null

    private var deviceDefenderIndexingMode: Output<String>? = null

    private var filter: Output<IndexingConfigurationThingIndexingConfigurationFilterArgs>? = null

    private var managedFields:
        Output<List<IndexingConfigurationThingIndexingConfigurationManagedFieldArgs>>? = null

    private var namedShadowIndexingMode: Output<String>? = null

    private var thingConnectivityIndexingMode: Output<String>? = null

    private var thingIndexingMode: Output<String>? = null

    /**
     * @param value Contains custom field names and their data type. See below.
     */
    @JvmName("uqntsvgrhfpdhaxu")
    public suspend
    fun customFields(`value`: Output<List<IndexingConfigurationThingIndexingConfigurationCustomFieldArgs>>) {
        this.customFields = value
    }

    @JvmName("sltxiyukparbopwo")
    public suspend fun customFields(
        vararg
        values: Output<IndexingConfigurationThingIndexingConfigurationCustomFieldArgs>,
    ) {
        this.customFields = Output.all(values.asList())
    }

    /**
     * @param values Contains custom field names and their data type. See below.
     */
    @JvmName("hbejumkoufvylidt")
    public suspend
    fun customFields(values: List<Output<IndexingConfigurationThingIndexingConfigurationCustomFieldArgs>>) {
        this.customFields = Output.all(values)
    }

    /**
     * @param value Device Defender indexing mode. Valid values: `VIOLATIONS`, `OFF`. Default: `OFF`.
     */
    @JvmName("cpxdvmsyrlyuldjs")
    public suspend fun deviceDefenderIndexingMode(`value`: Output<String>) {
        this.deviceDefenderIndexingMode = value
    }

    /**
     * @param value Required if `named_shadow_indexing_mode` is `ON`. Enables to add named shadows filtered by `filter` to fleet indexing configuration.
     */
    @JvmName("skcaljxvqffdwvux")
    public suspend
    fun filter(`value`: Output<IndexingConfigurationThingIndexingConfigurationFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("njaxhuotvjrtxsot")
    public suspend
    fun managedFields(`value`: Output<List<IndexingConfigurationThingIndexingConfigurationManagedFieldArgs>>) {
        this.managedFields = value
    }

    @JvmName("hnxebijsofievekn")
    public suspend fun managedFields(
        vararg
        values: Output<IndexingConfigurationThingIndexingConfigurationManagedFieldArgs>,
    ) {
        this.managedFields = Output.all(values.asList())
    }

    /**
     * @param values Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("jjsatciaegpkythg")
    public suspend
    fun managedFields(values: List<Output<IndexingConfigurationThingIndexingConfigurationManagedFieldArgs>>) {
        this.managedFields = Output.all(values)
    }

    /**
     * @param value [Named shadow](https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html) indexing mode. Valid values: `ON`, `OFF`. Default: `OFF`.
     */
    @JvmName("ceglylisowoexvkh")
    public suspend fun namedShadowIndexingMode(`value`: Output<String>) {
        this.namedShadowIndexingMode = value
    }

    /**
     * @param value Thing connectivity indexing mode. Valid values: `STATUS`, `OFF`. Default: `OFF`.
     */
    @JvmName("ewtwfhafhbvovxqk")
    public suspend fun thingConnectivityIndexingMode(`value`: Output<String>) {
        this.thingConnectivityIndexingMode = value
    }

    /**
     * @param value Thing indexing mode. Valid values: `REGISTRY`, `REGISTRY_AND_SHADOW`, `OFF`.
     */
    @JvmName("xbretfcsnoxpykbd")
    public suspend fun thingIndexingMode(`value`: Output<String>) {
        this.thingIndexingMode = value
    }

    /**
     * @param value Contains custom field names and their data type. See below.
     */
    @JvmName("meaplxqsbltykiaj")
    public suspend
    fun customFields(`value`: List<IndexingConfigurationThingIndexingConfigurationCustomFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customFields = mapped
    }

    /**
     * @param argument Contains custom field names and their data type. See below.
     */
    @JvmName("porkrkvtriswxvna")
    public suspend
    fun customFields(argument: List<suspend IndexingConfigurationThingIndexingConfigurationCustomFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IndexingConfigurationThingIndexingConfigurationCustomFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customFields = mapped
    }

    /**
     * @param argument Contains custom field names and their data type. See below.
     */
    @JvmName("sqibkpbdeqxummal")
    public suspend fun customFields(
        vararg
        argument: suspend IndexingConfigurationThingIndexingConfigurationCustomFieldArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IndexingConfigurationThingIndexingConfigurationCustomFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customFields = mapped
    }

    /**
     * @param argument Contains custom field names and their data type. See below.
     */
    @JvmName("dyfgnumatyqiddyl")
    public suspend
    fun customFields(argument: suspend IndexingConfigurationThingIndexingConfigurationCustomFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                IndexingConfigurationThingIndexingConfigurationCustomFieldArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.customFields = mapped
    }

    /**
     * @param values Contains custom field names and their data type. See below.
     */
    @JvmName("wmitgceeynhaqeof")
    public suspend fun customFields(
        vararg
        values: IndexingConfigurationThingIndexingConfigurationCustomFieldArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customFields = mapped
    }

    /**
     * @param value Device Defender indexing mode. Valid values: `VIOLATIONS`, `OFF`. Default: `OFF`.
     */
    @JvmName("doucfesuksvywdqg")
    public suspend fun deviceDefenderIndexingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceDefenderIndexingMode = mapped
    }

    /**
     * @param value Required if `named_shadow_indexing_mode` is `ON`. Enables to add named shadows filtered by `filter` to fleet indexing configuration.
     */
    @JvmName("einaotwiwlceqncu")
    public suspend fun filter(`value`: IndexingConfigurationThingIndexingConfigurationFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Required if `named_shadow_indexing_mode` is `ON`. Enables to add named shadows filtered by `filter` to fleet indexing configuration.
     */
    @JvmName("wxlcxkviuieckhji")
    public suspend
    fun filter(argument: suspend IndexingConfigurationThingIndexingConfigurationFilterArgsBuilder.() -> Unit) {
        val toBeMapped =
            IndexingConfigurationThingIndexingConfigurationFilterArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("tixaxublvjepqvro")
    public suspend
    fun managedFields(`value`: List<IndexingConfigurationThingIndexingConfigurationManagedFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedFields = mapped
    }

    /**
     * @param argument Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("doycxspnbywoxtox")
    public suspend
    fun managedFields(argument: List<suspend IndexingConfigurationThingIndexingConfigurationManagedFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IndexingConfigurationThingIndexingConfigurationManagedFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedFields = mapped
    }

    /**
     * @param argument Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("pdlhecxxeebffrcb")
    public suspend fun managedFields(
        vararg
        argument: suspend IndexingConfigurationThingIndexingConfigurationManagedFieldArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IndexingConfigurationThingIndexingConfigurationManagedFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedFields = mapped
    }

    /**
     * @param argument Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("gikatcorgingibga")
    public suspend
    fun managedFields(argument: suspend IndexingConfigurationThingIndexingConfigurationManagedFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                IndexingConfigurationThingIndexingConfigurationManagedFieldArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.managedFields = mapped
    }

    /**
     * @param values Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
     */
    @JvmName("svtdsovxnhirydjc")
    public suspend fun managedFields(
        vararg
        values: IndexingConfigurationThingIndexingConfigurationManagedFieldArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedFields = mapped
    }

    /**
     * @param value [Named shadow](https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html) indexing mode. Valid values: `ON`, `OFF`. Default: `OFF`.
     */
    @JvmName("lncvfrwqfjjybscp")
    public suspend fun namedShadowIndexingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namedShadowIndexingMode = mapped
    }

    /**
     * @param value Thing connectivity indexing mode. Valid values: `STATUS`, `OFF`. Default: `OFF`.
     */
    @JvmName("smbxqfidyddakuqx")
    public suspend fun thingConnectivityIndexingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingConnectivityIndexingMode = mapped
    }

    /**
     * @param value Thing indexing mode. Valid values: `REGISTRY`, `REGISTRY_AND_SHADOW`, `OFF`.
     */
    @JvmName("mojqkglxhoevuhof")
    public suspend fun thingIndexingMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thingIndexingMode = mapped
    }

    internal fun build(): IndexingConfigurationThingIndexingConfigurationArgs =
        IndexingConfigurationThingIndexingConfigurationArgs(
            customFields = customFields,
            deviceDefenderIndexingMode = deviceDefenderIndexingMode,
            filter = filter,
            managedFields = managedFields,
            namedShadowIndexingMode = namedShadowIndexingMode,
            thingConnectivityIndexingMode = thingConnectivityIndexingMode,
            thingIndexingMode = thingIndexingMode ?: throw PulumiNullFieldException("thingIndexingMode"),
        )
}
