@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property namedShadowNames List of shadow names that you select to index.
 */
public data class IndexingConfigurationThingIndexingConfigurationFilterArgs(
    public val namedShadowNames: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs> {
    override fun toJava():
        com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs =
        com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs.builder()
            .namedShadowNames(namedShadowNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [IndexingConfigurationThingIndexingConfigurationFilterArgs].
 */
@PulumiTagMarker
public class IndexingConfigurationThingIndexingConfigurationFilterArgsBuilder internal constructor() {
    private var namedShadowNames: Output<List<String>>? = null

    /**
     * @param value List of shadow names that you select to index.
     */
    @JvmName("odyehyctsitwmpyn")
    public suspend fun namedShadowNames(`value`: Output<List<String>>) {
        this.namedShadowNames = value
    }

    @JvmName("sfhtuaajjgoqfhwg")
    public suspend fun namedShadowNames(vararg values: Output<String>) {
        this.namedShadowNames = Output.all(values.asList())
    }

    /**
     * @param values List of shadow names that you select to index.
     */
    @JvmName("flfafkrkxchkqesk")
    public suspend fun namedShadowNames(values: List<Output<String>>) {
        this.namedShadowNames = Output.all(values)
    }

    /**
     * @param value List of shadow names that you select to index.
     */
    @JvmName("kepwtrjtfmblxlxg")
    public suspend fun namedShadowNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namedShadowNames = mapped
    }

    /**
     * @param values List of shadow names that you select to index.
     */
    @JvmName("ewxolexcpvvgnekd")
    public suspend fun namedShadowNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namedShadowNames = mapped
    }

    internal fun build(): IndexingConfigurationThingIndexingConfigurationFilterArgs =
        IndexingConfigurationThingIndexingConfigurationFilterArgs(
            namedShadowNames = namedShadowNames,
        )
}
