@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.ThingGroupPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property attributePayload The Thing Group attributes. Defined below.
 * @property description A description of the Thing Group.
 */
public data class ThingGroupPropertiesArgs(
    public val attributePayload: Output<ThingGroupPropertiesAttributePayloadArgs>? = null,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.ThingGroupPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.ThingGroupPropertiesArgs =
        com.pulumi.aws.iot.inputs.ThingGroupPropertiesArgs.builder()
            .attributePayload(attributePayload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThingGroupPropertiesArgs].
 */
@PulumiTagMarker
public class ThingGroupPropertiesArgsBuilder internal constructor() {
    private var attributePayload: Output<ThingGroupPropertiesAttributePayloadArgs>? = null

    private var description: Output<String>? = null

    /**
     * @param value The Thing Group attributes. Defined below.
     */
    @JvmName("seqxmymthvtlokic")
    public suspend fun attributePayload(`value`: Output<ThingGroupPropertiesAttributePayloadArgs>) {
        this.attributePayload = value
    }

    /**
     * @param value A description of the Thing Group.
     */
    @JvmName("muvtlbrmajuckgts")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Thing Group attributes. Defined below.
     */
    @JvmName("bqostoiqnbrtdyox")
    public suspend fun attributePayload(`value`: ThingGroupPropertiesAttributePayloadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributePayload = mapped
    }

    /**
     * @param argument The Thing Group attributes. Defined below.
     */
    @JvmName("axrkqcsjkbddodmi")
    public suspend
    fun attributePayload(argument: suspend ThingGroupPropertiesAttributePayloadArgsBuilder.() -> Unit) {
        val toBeMapped = ThingGroupPropertiesAttributePayloadArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.attributePayload = mapped
    }

    /**
     * @param value A description of the Thing Group.
     */
    @JvmName("wqrcngwfurpasivm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): ThingGroupPropertiesArgs = ThingGroupPropertiesArgs(
        attributePayload = attributePayload,
        description = description,
    )
}
