@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleCloudwatchLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroupName The CloudWatch log group name.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 */
public data class TopicRuleCloudwatchLogArgs(
    public val logGroupName: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleCloudwatchLogArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleCloudwatchLogArgs =
        com.pulumi.aws.iot.inputs.TopicRuleCloudwatchLogArgs.builder()
            .logGroupName(logGroupName.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleCloudwatchLogArgs].
 */
@PulumiTagMarker
public class TopicRuleCloudwatchLogArgsBuilder internal constructor() {
    private var logGroupName: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The CloudWatch log group name.
     */
    @JvmName("loprbiiybpnhcyqq")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("exteihyjrnfhkumx")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The CloudWatch log group name.
     */
    @JvmName("yuccxpxkgermueif")
    public suspend fun logGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("bwxcplljeynbtsxo")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleCloudwatchLogArgs = TopicRuleCloudwatchLogArgs(
        logGroupName = logGroupName ?: throw PulumiNullFieldException("logGroupName"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
