@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleDynamodbArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hashKeyField The hash key name.
 * @property hashKeyType The hash key type. Valid values are "STRING" or "NUMBER".
 * @property hashKeyValue The hash key value.
 * @property operation The operation. Valid values are "INSERT", "UPDATE", or "DELETE".
 * @property payloadField The action payload.
 * @property rangeKeyField The range key name.
 * @property rangeKeyType The range key type. Valid values are "STRING" or "NUMBER".
 * @property rangeKeyValue The range key value.
 * @property roleArn The ARN of the IAM role that grants access to the DynamoDB table.
 * @property tableName The name of the DynamoDB table.
 */
public data class TopicRuleDynamodbArgs(
    public val hashKeyField: Output<String>,
    public val hashKeyType: Output<String>? = null,
    public val hashKeyValue: Output<String>,
    public val operation: Output<String>? = null,
    public val payloadField: Output<String>? = null,
    public val rangeKeyField: Output<String>? = null,
    public val rangeKeyType: Output<String>? = null,
    public val rangeKeyValue: Output<String>? = null,
    public val roleArn: Output<String>,
    public val tableName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleDynamodbArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleDynamodbArgs =
        com.pulumi.aws.iot.inputs.TopicRuleDynamodbArgs.builder()
            .hashKeyField(hashKeyField.applyValue({ args0 -> args0 }))
            .hashKeyType(hashKeyType?.applyValue({ args0 -> args0 }))
            .hashKeyValue(hashKeyValue.applyValue({ args0 -> args0 }))
            .operation(operation?.applyValue({ args0 -> args0 }))
            .payloadField(payloadField?.applyValue({ args0 -> args0 }))
            .rangeKeyField(rangeKeyField?.applyValue({ args0 -> args0 }))
            .rangeKeyType(rangeKeyType?.applyValue({ args0 -> args0 }))
            .rangeKeyValue(rangeKeyValue?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleDynamodbArgs].
 */
@PulumiTagMarker
public class TopicRuleDynamodbArgsBuilder internal constructor() {
    private var hashKeyField: Output<String>? = null

    private var hashKeyType: Output<String>? = null

    private var hashKeyValue: Output<String>? = null

    private var operation: Output<String>? = null

    private var payloadField: Output<String>? = null

    private var rangeKeyField: Output<String>? = null

    private var rangeKeyType: Output<String>? = null

    private var rangeKeyValue: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The hash key name.
     */
    @JvmName("bgvtkbsbrvtqjwfq")
    public suspend fun hashKeyField(`value`: Output<String>) {
        this.hashKeyField = value
    }

    /**
     * @param value The hash key type. Valid values are "STRING" or "NUMBER".
     */
    @JvmName("jyedpigwjsemgtyy")
    public suspend fun hashKeyType(`value`: Output<String>) {
        this.hashKeyType = value
    }

    /**
     * @param value The hash key value.
     */
    @JvmName("amntkrmuqlvajveo")
    public suspend fun hashKeyValue(`value`: Output<String>) {
        this.hashKeyValue = value
    }

    /**
     * @param value The operation. Valid values are "INSERT", "UPDATE", or "DELETE".
     */
    @JvmName("fnweagsiyijsrqae")
    public suspend fun operation(`value`: Output<String>) {
        this.operation = value
    }

    /**
     * @param value The action payload.
     */
    @JvmName("fxkvbhqhibjmnkji")
    public suspend fun payloadField(`value`: Output<String>) {
        this.payloadField = value
    }

    /**
     * @param value The range key name.
     */
    @JvmName("mtwodghjnsegocfq")
    public suspend fun rangeKeyField(`value`: Output<String>) {
        this.rangeKeyField = value
    }

    /**
     * @param value The range key type. Valid values are "STRING" or "NUMBER".
     */
    @JvmName("xvtrjhnaghtfqtlp")
    public suspend fun rangeKeyType(`value`: Output<String>) {
        this.rangeKeyType = value
    }

    /**
     * @param value The range key value.
     */
    @JvmName("tnfyccgyalejldvl")
    public suspend fun rangeKeyValue(`value`: Output<String>) {
        this.rangeKeyValue = value
    }

    /**
     * @param value The ARN of the IAM role that grants access to the DynamoDB table.
     */
    @JvmName("sbicrqywhasbeaqm")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the DynamoDB table.
     */
    @JvmName("ipowemivrieynsws")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The hash key name.
     */
    @JvmName("dktbxaxntlkqnadd")
    public suspend fun hashKeyField(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hashKeyField = mapped
    }

    /**
     * @param value The hash key type. Valid values are "STRING" or "NUMBER".
     */
    @JvmName("nucenmlkljtoieyi")
    public suspend fun hashKeyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hashKeyType = mapped
    }

    /**
     * @param value The hash key value.
     */
    @JvmName("becupamxpiffwloy")
    public suspend fun hashKeyValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hashKeyValue = mapped
    }

    /**
     * @param value The operation. Valid values are "INSERT", "UPDATE", or "DELETE".
     */
    @JvmName("gvpkmjygmhucpaan")
    public suspend fun operation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value The action payload.
     */
    @JvmName("woygmstwljwsvpwc")
    public suspend fun payloadField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payloadField = mapped
    }

    /**
     * @param value The range key name.
     */
    @JvmName("qqxvgfoqixphtbfl")
    public suspend fun rangeKeyField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rangeKeyField = mapped
    }

    /**
     * @param value The range key type. Valid values are "STRING" or "NUMBER".
     */
    @JvmName("hvmnqahpynitmebw")
    public suspend fun rangeKeyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rangeKeyType = mapped
    }

    /**
     * @param value The range key value.
     */
    @JvmName("ecrtmalkgclvdgpg")
    public suspend fun rangeKeyValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rangeKeyValue = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access to the DynamoDB table.
     */
    @JvmName("coaldyhsysfwmwhb")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the DynamoDB table.
     */
    @JvmName("mbihkkevoulxxpjs")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): TopicRuleDynamodbArgs = TopicRuleDynamodbArgs(
        hashKeyField = hashKeyField ?: throw PulumiNullFieldException("hashKeyField"),
        hashKeyType = hashKeyType,
        hashKeyValue = hashKeyValue ?: throw PulumiNullFieldException("hashKeyValue"),
        operation = operation,
        payloadField = payloadField,
        rangeKeyField = rangeKeyField,
        rangeKeyType = rangeKeyType,
        rangeKeyValue = rangeKeyValue,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
