@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleElasticsearchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpoint The endpoint of your Elasticsearch domain.
 * @property id The unique identifier for the document you are storing.
 * @property index The Elasticsearch index where you want to store your data.
 * @property roleArn The IAM role ARN that has access to Elasticsearch.
 * @property type The type of document you are storing.
 */
public data class TopicRuleElasticsearchArgs(
    public val endpoint: Output<String>,
    public val id: Output<String>,
    public val index: Output<String>,
    public val roleArn: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleElasticsearchArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleElasticsearchArgs =
        com.pulumi.aws.iot.inputs.TopicRuleElasticsearchArgs.builder()
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .index(index.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleElasticsearchArgs].
 */
@PulumiTagMarker
public class TopicRuleElasticsearchArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var id: Output<String>? = null

    private var index: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The endpoint of your Elasticsearch domain.
     */
    @JvmName("tsymbdetalqxhqhq")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The unique identifier for the document you are storing.
     */
    @JvmName("gheerpnjwfmdvxmc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The Elasticsearch index where you want to store your data.
     */
    @JvmName("iwkchqlshihgstla")
    public suspend fun index(`value`: Output<String>) {
        this.index = value
    }

    /**
     * @param value The IAM role ARN that has access to Elasticsearch.
     */
    @JvmName("ggykaspenjvenjdq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The type of document you are storing.
     */
    @JvmName("lhpwlbjbwhwvhnug")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The endpoint of your Elasticsearch domain.
     */
    @JvmName("iydcvasmbdhurhry")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The unique identifier for the document you are storing.
     */
    @JvmName("sndxcwgxuhpsxvfl")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The Elasticsearch index where you want to store your data.
     */
    @JvmName("esoqfigywbuaictn")
    public suspend fun index(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.index = mapped
    }

    /**
     * @param value The IAM role ARN that has access to Elasticsearch.
     */
    @JvmName("gxfidrvnmqnvylmo")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The type of document you are storing.
     */
    @JvmName("jlleodxhmnuvfoqx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TopicRuleElasticsearchArgs = TopicRuleElasticsearchArgs(
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        id = id ?: throw PulumiNullFieldException("id"),
        index = index ?: throw PulumiNullFieldException("index"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
