@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchAlarmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alarmName The CloudWatch alarm name.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 * @property stateReason The reason for the alarm change.
 * @property stateValue The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
 */
public data class TopicRuleErrorActionCloudwatchAlarmArgs(
    public val alarmName: Output<String>,
    public val roleArn: Output<String>,
    public val stateReason: Output<String>,
    public val stateValue: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchAlarmArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchAlarmArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchAlarmArgs.builder()
            .alarmName(alarmName.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .stateReason(stateReason.applyValue({ args0 -> args0 }))
            .stateValue(stateValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionCloudwatchAlarmArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionCloudwatchAlarmArgsBuilder internal constructor() {
    private var alarmName: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var stateReason: Output<String>? = null

    private var stateValue: Output<String>? = null

    /**
     * @param value The CloudWatch alarm name.
     */
    @JvmName("amimetlxkkoxqsfs")
    public suspend fun alarmName(`value`: Output<String>) {
        this.alarmName = value
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("shaypqojewawyjsr")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The reason for the alarm change.
     */
    @JvmName("swuhoskimdwgmbem")
    public suspend fun stateReason(`value`: Output<String>) {
        this.stateReason = value
    }

    /**
     * @param value The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
     */
    @JvmName("rsvfeatcoablpgyh")
    public suspend fun stateValue(`value`: Output<String>) {
        this.stateValue = value
    }

    /**
     * @param value The CloudWatch alarm name.
     */
    @JvmName("xayjobhabdceorid")
    public suspend fun alarmName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarmName = mapped
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("kuogftbyvecelafp")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The reason for the alarm change.
     */
    @JvmName("qqflgincqsffeyhm")
    public suspend fun stateReason(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stateReason = mapped
    }

    /**
     * @param value The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
     */
    @JvmName("acnxbslbegtjugjn")
    public suspend fun stateValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stateValue = mapped
    }

    internal fun build(): TopicRuleErrorActionCloudwatchAlarmArgs =
        TopicRuleErrorActionCloudwatchAlarmArgs(
            alarmName = alarmName ?: throw PulumiNullFieldException("alarmName"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            stateReason = stateReason ?: throw PulumiNullFieldException("stateReason"),
            stateValue = stateValue ?: throw PulumiNullFieldException("stateValue"),
        )
}
