@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroupName The CloudWatch log group name.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 */
public data class TopicRuleErrorActionCloudwatchLogsArgs(
    public val logGroupName: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchLogsArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchLogsArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchLogsArgs.builder()
            .logGroupName(logGroupName.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionCloudwatchLogsArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionCloudwatchLogsArgsBuilder internal constructor() {
    private var logGroupName: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The CloudWatch log group name.
     */
    @JvmName("yceokoijlehqmjtt")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("guvttdllngfpniwj")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The CloudWatch log group name.
     */
    @JvmName("djpvuufovscsayfw")
    public suspend fun logGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("xyhylilqltjqvhnd")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleErrorActionCloudwatchLogsArgs =
        TopicRuleErrorActionCloudwatchLogsArgs(
            logGroupName = logGroupName ?: throw PulumiNullFieldException("logGroupName"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
