@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metricName The CloudWatch metric name.
 * @property metricNamespace The CloudWatch metric namespace name.
 * @property metricTimestamp An optional Unix timestamp (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
 * @property metricUnit The metric unit (supported units can be found here: http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit)
 * @property metricValue The CloudWatch metric value.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch metric.
 */
public data class TopicRuleErrorActionCloudwatchMetricArgs(
    public val metricName: Output<String>,
    public val metricNamespace: Output<String>,
    public val metricTimestamp: Output<String>? = null,
    public val metricUnit: Output<String>,
    public val metricValue: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchMetricArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchMetricArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionCloudwatchMetricArgs.builder()
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .metricNamespace(metricNamespace.applyValue({ args0 -> args0 }))
            .metricTimestamp(metricTimestamp?.applyValue({ args0 -> args0 }))
            .metricUnit(metricUnit.applyValue({ args0 -> args0 }))
            .metricValue(metricValue.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionCloudwatchMetricArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionCloudwatchMetricArgsBuilder internal constructor() {
    private var metricName: Output<String>? = null

    private var metricNamespace: Output<String>? = null

    private var metricTimestamp: Output<String>? = null

    private var metricUnit: Output<String>? = null

    private var metricValue: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The CloudWatch metric name.
     */
    @JvmName("aefmiarybwtfptkl")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The CloudWatch metric namespace name.
     */
    @JvmName("fladrghvmevlnxpe")
    public suspend fun metricNamespace(`value`: Output<String>) {
        this.metricNamespace = value
    }

    /**
     * @param value An optional Unix timestamp (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
     */
    @JvmName("hriomjktuyqalbsh")
    public suspend fun metricTimestamp(`value`: Output<String>) {
        this.metricTimestamp = value
    }

    /**
     * @param value The metric unit (supported units can be found here: http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit)
     */
    @JvmName("sajwqjinhcuiyrxq")
    public suspend fun metricUnit(`value`: Output<String>) {
        this.metricUnit = value
    }

    /**
     * @param value The CloudWatch metric value.
     */
    @JvmName("xlnjtpbjvjwwebjc")
    public suspend fun metricValue(`value`: Output<String>) {
        this.metricValue = value
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch metric.
     */
    @JvmName("bvgasbrekaugjujl")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The CloudWatch metric name.
     */
    @JvmName("vupscspwyaaeidet")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The CloudWatch metric namespace name.
     */
    @JvmName("hlwidxsegfdtftfr")
    public suspend fun metricNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricNamespace = mapped
    }

    /**
     * @param value An optional Unix timestamp (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
     */
    @JvmName("llmspammrjlqqvgl")
    public suspend fun metricTimestamp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricTimestamp = mapped
    }

    /**
     * @param value The metric unit (supported units can be found here: http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit)
     */
    @JvmName("taocupmiimbgjesf")
    public suspend fun metricUnit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricUnit = mapped
    }

    /**
     * @param value The CloudWatch metric value.
     */
    @JvmName("lopxxnhkgqpfivdk")
    public suspend fun metricValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricValue = mapped
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch metric.
     */
    @JvmName("aviecttfmqsreqjb")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleErrorActionCloudwatchMetricArgs =
        TopicRuleErrorActionCloudwatchMetricArgs(
            metricName = metricName ?: throw PulumiNullFieldException("metricName"),
            metricNamespace = metricNamespace ?: throw PulumiNullFieldException("metricNamespace"),
            metricTimestamp = metricTimestamp,
            metricUnit = metricUnit ?: throw PulumiNullFieldException("metricUnit"),
            metricValue = metricValue ?: throw PulumiNullFieldException("metricValue"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
