@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionDynamodbv2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property putItem Configuration block with DynamoDB Table to which the message will be written. Nested arguments below.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 */
public data class TopicRuleErrorActionDynamodbv2Args(
    public val putItem: Output<TopicRuleErrorActionDynamodbv2PutItemArgs>? = null,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionDynamodbv2Args> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionDynamodbv2Args =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionDynamodbv2Args.builder()
            .putItem(putItem?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionDynamodbv2Args].
 */
@PulumiTagMarker
public class TopicRuleErrorActionDynamodbv2ArgsBuilder internal constructor() {
    private var putItem: Output<TopicRuleErrorActionDynamodbv2PutItemArgs>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value Configuration block with DynamoDB Table to which the message will be written. Nested arguments below.
     */
    @JvmName("pyumvoanucepslmd")
    public suspend fun putItem(`value`: Output<TopicRuleErrorActionDynamodbv2PutItemArgs>) {
        this.putItem = value
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("tgwsyoobpfjqjefi")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Configuration block with DynamoDB Table to which the message will be written. Nested arguments below.
     */
    @JvmName("quojhfquqyjfkdrp")
    public suspend fun putItem(`value`: TopicRuleErrorActionDynamodbv2PutItemArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.putItem = mapped
    }

    /**
     * @param argument Configuration block with DynamoDB Table to which the message will be written. Nested arguments below.
     */
    @JvmName("lufajnadmkgstofw")
    public suspend
    fun putItem(argument: suspend TopicRuleErrorActionDynamodbv2PutItemArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionDynamodbv2PutItemArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.putItem = mapped
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("lmiknbpjvwywvvcs")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleErrorActionDynamodbv2Args = TopicRuleErrorActionDynamodbv2Args(
        putItem = putItem,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
