@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionIotEventsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchMode The payload that contains a JSON array of records will be sent to IoT Events via a batch call.
 * @property inputName The name of the AWS IoT Events input.
 * @property messageId Use this to ensure that only one input (message) with a given messageId is processed by an AWS IoT Events detector.
 * @property roleArn The ARN of the IAM role that grants access.
 */
public data class TopicRuleErrorActionIotEventsArgs(
    public val batchMode: Output<Boolean>? = null,
    public val inputName: Output<String>,
    public val messageId: Output<String>? = null,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionIotEventsArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionIotEventsArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionIotEventsArgs.builder()
            .batchMode(batchMode?.applyValue({ args0 -> args0 }))
            .inputName(inputName.applyValue({ args0 -> args0 }))
            .messageId(messageId?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionIotEventsArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionIotEventsArgsBuilder internal constructor() {
    private var batchMode: Output<Boolean>? = null

    private var inputName: Output<String>? = null

    private var messageId: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The payload that contains a JSON array of records will be sent to IoT Events via a batch call.
     */
    @JvmName("biemtbibggfekmxa")
    public suspend fun batchMode(`value`: Output<Boolean>) {
        this.batchMode = value
    }

    /**
     * @param value The name of the AWS IoT Events input.
     */
    @JvmName("fakxetbrsegrjbgj")
    public suspend fun inputName(`value`: Output<String>) {
        this.inputName = value
    }

    /**
     * @param value Use this to ensure that only one input (message) with a given messageId is processed by an AWS IoT Events detector.
     */
    @JvmName("gqqigysyutxbadjy")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("gggupejwpoubukfj")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The payload that contains a JSON array of records will be sent to IoT Events via a batch call.
     */
    @JvmName("oqwarejcrdsummwk")
    public suspend fun batchMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchMode = mapped
    }

    /**
     * @param value The name of the AWS IoT Events input.
     */
    @JvmName("sjbclyvupfwghown")
    public suspend fun inputName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputName = mapped
    }

    /**
     * @param value Use this to ensure that only one input (message) with a given messageId is processed by an AWS IoT Events detector.
     */
    @JvmName("pwqpfjktjvtbpjuu")
    public suspend fun messageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("irqbufyvydtnalwd")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleErrorActionIotEventsArgs = TopicRuleErrorActionIotEventsArgs(
        batchMode = batchMode,
        inputName = inputName ?: throw PulumiNullFieldException("inputName"),
        messageId = messageId,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
