@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionKafkaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property clientProperties Properties of the Apache Kafka producer client. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/apache-kafka-rule-action.html).
 * @property destinationArn The ARN of Kafka action's VPC `aws.iot.TopicRuleDestination`.
 * @property headers The list of Kafka headers that you specify. Nested arguments below.
 * @property key The Kafka message key.
 * @property partition The Kafka message partition.
 * @property topic The Kafka topic for messages to be sent to the Kafka broker.
 */
public data class TopicRuleErrorActionKafkaArgs(
    public val clientProperties: Output<Map<String, String>>,
    public val destinationArn: Output<String>,
    public val headers: Output<List<TopicRuleErrorActionKafkaHeaderArgs>>? = null,
    public val key: Output<String>? = null,
    public val partition: Output<String>? = null,
    public val topic: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionKafkaArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionKafkaArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionKafkaArgs.builder()
            .clientProperties(
                clientProperties.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .destinationArn(destinationArn.applyValue({ args0 -> args0 }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .key(key?.applyValue({ args0 -> args0 }))
            .partition(partition?.applyValue({ args0 -> args0 }))
            .topic(topic.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionKafkaArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionKafkaArgsBuilder internal constructor() {
    private var clientProperties: Output<Map<String, String>>? = null

    private var destinationArn: Output<String>? = null

    private var headers: Output<List<TopicRuleErrorActionKafkaHeaderArgs>>? = null

    private var key: Output<String>? = null

    private var partition: Output<String>? = null

    private var topic: Output<String>? = null

    /**
     * @param value Properties of the Apache Kafka producer client. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/apache-kafka-rule-action.html).
     */
    @JvmName("mufvcgsobmdtoclq")
    public suspend fun clientProperties(`value`: Output<Map<String, String>>) {
        this.clientProperties = value
    }

    /**
     * @param value The ARN of Kafka action's VPC `aws.iot.TopicRuleDestination`.
     */
    @JvmName("mtdbbpfepaqmqikp")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("gdvudvfmtcsfvhue")
    public suspend fun headers(`value`: Output<List<TopicRuleErrorActionKafkaHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("nafwmdjdnlekkqvg")
    public suspend fun headers(vararg values: Output<TopicRuleErrorActionKafkaHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("obdgmphedjcvwbtj")
    public suspend fun headers(values: List<Output<TopicRuleErrorActionKafkaHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value The Kafka message key.
     */
    @JvmName("aalfybltghhxnffb")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The Kafka message partition.
     */
    @JvmName("tkponhfiqrpqpgnq")
    public suspend fun partition(`value`: Output<String>) {
        this.partition = value
    }

    /**
     * @param value The Kafka topic for messages to be sent to the Kafka broker.
     */
    @JvmName("jfhlrvdjguvwkubp")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Properties of the Apache Kafka producer client. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/apache-kafka-rule-action.html).
     */
    @JvmName("ohpcshgircrmxwvg")
    public suspend fun clientProperties(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientProperties = mapped
    }

    /**
     * @param values Properties of the Apache Kafka producer client. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/apache-kafka-rule-action.html).
     */
    @JvmName("xxfouqhbpapdyecm")
    public fun clientProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientProperties = mapped
    }

    /**
     * @param value The ARN of Kafka action's VPC `aws.iot.TopicRuleDestination`.
     */
    @JvmName("fsrdjvjhnxvuqnlr")
    public suspend fun destinationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("qiybjgobdichwuby")
    public suspend fun headers(`value`: List<TopicRuleErrorActionKafkaHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("iocyuvlmjfsoxmbw")
    public suspend
    fun headers(argument: List<suspend TopicRuleErrorActionKafkaHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleErrorActionKafkaHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("ngbnfuskhwktnjub")
    public suspend fun headers(
        vararg
        argument: suspend TopicRuleErrorActionKafkaHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleErrorActionKafkaHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("fojtjqanxlormvdw")
    public suspend
    fun headers(argument: suspend TopicRuleErrorActionKafkaHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TopicRuleErrorActionKafkaHeaderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("aisjyjaduvmmdvky")
    public suspend fun headers(vararg values: TopicRuleErrorActionKafkaHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value The Kafka message key.
     */
    @JvmName("ronmuhpmwbqbcaii")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The Kafka message partition.
     */
    @JvmName("gqmjmnihgfjptjnv")
    public suspend fun partition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partition = mapped
    }

    /**
     * @param value The Kafka topic for messages to be sent to the Kafka broker.
     */
    @JvmName("okehhysyiwfvgtbu")
    public suspend fun topic(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): TopicRuleErrorActionKafkaArgs = TopicRuleErrorActionKafkaArgs(
        clientProperties = clientProperties ?: throw PulumiNullFieldException("clientProperties"),
        destinationArn = destinationArn ?: throw PulumiNullFieldException("destinationArn"),
        headers = headers,
        key = key,
        partition = partition,
        topic = topic ?: throw PulumiNullFieldException("topic"),
    )
}
