@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionKafkaHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The name of the HTTP header.
 * @property value The value of the HTTP header.
 */
public data class TopicRuleErrorActionKafkaHeaderArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionKafkaHeaderArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionKafkaHeaderArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionKafkaHeaderArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionKafkaHeaderArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionKafkaHeaderArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the HTTP header.
     */
    @JvmName("lrgnsbvovfrtawyv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value of the HTTP header.
     */
    @JvmName("gqhmkdwkbnknxuoy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the HTTP header.
     */
    @JvmName("teltuxcbpeipmiar")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value of the HTTP header.
     */
    @JvmName("deyvtfohtxywteyx")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TopicRuleErrorActionKafkaHeaderArgs = TopicRuleErrorActionKafkaHeaderArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
