@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionKinesisArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partitionKey The partition key.
 * @property roleArn The ARN of the IAM role that grants access to the Amazon Kinesis stream.
 * @property streamName The name of the Amazon Kinesis stream.
 */
public data class TopicRuleErrorActionKinesisArgs(
    public val partitionKey: Output<String>? = null,
    public val roleArn: Output<String>,
    public val streamName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionKinesisArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionKinesisArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionKinesisArgs.builder()
            .partitionKey(partitionKey?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .streamName(streamName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionKinesisArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionKinesisArgsBuilder internal constructor() {
    private var partitionKey: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var streamName: Output<String>? = null

    /**
     * @param value The partition key.
     */
    @JvmName("byktihknayhfmmac")
    public suspend fun partitionKey(`value`: Output<String>) {
        this.partitionKey = value
    }

    /**
     * @param value The ARN of the IAM role that grants access to the Amazon Kinesis stream.
     */
    @JvmName("gipsmketmchvhers")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the Amazon Kinesis stream.
     */
    @JvmName("fpjtqkbsorekktas")
    public suspend fun streamName(`value`: Output<String>) {
        this.streamName = value
    }

    /**
     * @param value The partition key.
     */
    @JvmName("hthikxenturllijr")
    public suspend fun partitionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access to the Amazon Kinesis stream.
     */
    @JvmName("dlrnuvcdytkpkpgd")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the Amazon Kinesis stream.
     */
    @JvmName("eepurvrgkprvovhy")
    public suspend fun streamName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamName = mapped
    }

    internal fun build(): TopicRuleErrorActionKinesisArgs = TopicRuleErrorActionKinesisArgs(
        partitionKey = partitionKey,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        streamName = streamName ?: throw PulumiNullFieldException("streamName"),
    )
}
