@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionSqsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property queueUrl The URL of the Amazon SQS queue.
 * @property roleArn The ARN of the IAM role that grants access.
 * @property useBase64 Specifies whether to use Base64 encoding.
 */
public data class TopicRuleErrorActionSqsArgs(
    public val queueUrl: Output<String>,
    public val roleArn: Output<String>,
    public val useBase64: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionSqsArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionSqsArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionSqsArgs.builder()
            .queueUrl(queueUrl.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .useBase64(useBase64.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionSqsArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionSqsArgsBuilder internal constructor() {
    private var queueUrl: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var useBase64: Output<Boolean>? = null

    /**
     * @param value The URL of the Amazon SQS queue.
     */
    @JvmName("uhuxbrgitnlugcxs")
    public suspend fun queueUrl(`value`: Output<String>) {
        this.queueUrl = value
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("ncsbsrupdbokrwoi")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Specifies whether to use Base64 encoding.
     */
    @JvmName("abkjqfxmhufjeyjq")
    public suspend fun useBase64(`value`: Output<Boolean>) {
        this.useBase64 = value
    }

    /**
     * @param value The URL of the Amazon SQS queue.
     */
    @JvmName("kthspleyjtjlrivc")
    public suspend fun queueUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queueUrl = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("vioviqijpqyndjsn")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Specifies whether to use Base64 encoding.
     */
    @JvmName("rxxutibuadigvais")
    public suspend fun useBase64(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useBase64 = mapped
    }

    internal fun build(): TopicRuleErrorActionSqsArgs = TopicRuleErrorActionSqsArgs(
        queueUrl = queueUrl ?: throw PulumiNullFieldException("queueUrl"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        useBase64 = useBase64 ?: throw PulumiNullFieldException("useBase64"),
    )
}
