@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the rule.
 * @property value The value of the HTTP header.
 */
public data class TopicRuleErrorActionTimestreamDimensionArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamDimensionArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamDimensionArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamDimensionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionTimestreamDimensionArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionTimestreamDimensionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the rule.
     */
    @JvmName("eujqnftrwnprmonp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the HTTP header.
     */
    @JvmName("dbdqgbvryfysmgcf")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("fdgenkvrdapwtugw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the HTTP header.
     */
    @JvmName("hpmdiydwbvwuiuys")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TopicRuleErrorActionTimestreamDimensionArgs =
        TopicRuleErrorActionTimestreamDimensionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
