@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleKafkaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property clientProperties Properties of the Apache Kafka producer client. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/apache-kafka-rule-action.html).
 * @property destinationArn The ARN of Kafka action's VPC `aws.iot.TopicRuleDestination`.
 * @property headers The list of Kafka headers that you specify. Nested arguments below.
 * @property key The Kafka message key.
 * @property partition The Kafka message partition.
 * @property topic The Kafka topic for messages to be sent to the Kafka broker.
 */
public data class TopicRuleKafkaArgs(
    public val clientProperties: Output<Map<String, String>>,
    public val destinationArn: Output<String>,
    public val headers: Output<List<TopicRuleKafkaHeaderArgs>>? = null,
    public val key: Output<String>? = null,
    public val partition: Output<String>? = null,
    public val topic: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleKafkaArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleKafkaArgs =
        com.pulumi.aws.iot.inputs.TopicRuleKafkaArgs.builder()
            .clientProperties(
                clientProperties.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .destinationArn(destinationArn.applyValue({ args0 -> args0 }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .key(key?.applyValue({ args0 -> args0 }))
            .partition(partition?.applyValue({ args0 -> args0 }))
            .topic(topic.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleKafkaArgs].
 */
@PulumiTagMarker
public class TopicRuleKafkaArgsBuilder internal constructor() {
    private var clientProperties: Output<Map<String, String>>? = null

    private var destinationArn: Output<String>? = null

    private var headers: Output<List<TopicRuleKafkaHeaderArgs>>? = null

    private var key: Output<String>? = null

    private var partition: Output<String>? = null

    private var topic: Output<String>? = null

    /**
     * @param value Properties of the Apache Kafka producer client. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/apache-kafka-rule-action.html).
     */
    @JvmName("kpawdqnekbpagvaw")
    public suspend fun clientProperties(`value`: Output<Map<String, String>>) {
        this.clientProperties = value
    }

    /**
     * @param value The ARN of Kafka action's VPC `aws.iot.TopicRuleDestination`.
     */
    @JvmName("fcmrchalyjkvtksx")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("tksgbxjnlfubcviu")
    public suspend fun headers(`value`: Output<List<TopicRuleKafkaHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("gveeyiywdycyvnju")
    public suspend fun headers(vararg values: Output<TopicRuleKafkaHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("evuigynpcovqwrab")
    public suspend fun headers(values: List<Output<TopicRuleKafkaHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value The Kafka message key.
     */
    @JvmName("ukydqetgpljwqbvo")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The Kafka message partition.
     */
    @JvmName("ddrksbymbnphqhlc")
    public suspend fun partition(`value`: Output<String>) {
        this.partition = value
    }

    /**
     * @param value The Kafka topic for messages to be sent to the Kafka broker.
     */
    @JvmName("gxwubsqncelviplj")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Properties of the Apache Kafka producer client. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/apache-kafka-rule-action.html).
     */
    @JvmName("tpdllgmxcaqmwkox")
    public suspend fun clientProperties(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientProperties = mapped
    }

    /**
     * @param values Properties of the Apache Kafka producer client. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/apache-kafka-rule-action.html).
     */
    @JvmName("gblrtsgvuoqhmujv")
    public fun clientProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientProperties = mapped
    }

    /**
     * @param value The ARN of Kafka action's VPC `aws.iot.TopicRuleDestination`.
     */
    @JvmName("eoebpvwjwcxclstb")
    public suspend fun destinationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("mgpxiyttunkhnxad")
    public suspend fun headers(`value`: List<TopicRuleKafkaHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("rxbepreicpeivbhy")
    public suspend fun headers(argument: List<suspend TopicRuleKafkaHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleKafkaHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("mkbdfyxwodwxcahv")
    public suspend fun headers(vararg argument: suspend TopicRuleKafkaHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleKafkaHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("puackbeppdchjujy")
    public suspend fun headers(argument: suspend TopicRuleKafkaHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleKafkaHeaderArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values The list of Kafka headers that you specify. Nested arguments below.
     */
    @JvmName("wpjdnwjovikrcgmi")
    public suspend fun headers(vararg values: TopicRuleKafkaHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value The Kafka message key.
     */
    @JvmName("thbhovyjknoeafri")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The Kafka message partition.
     */
    @JvmName("tcdohtjltngkwcpv")
    public suspend fun partition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partition = mapped
    }

    /**
     * @param value The Kafka topic for messages to be sent to the Kafka broker.
     */
    @JvmName("sjwqbxrdrpnctvhv")
    public suspend fun topic(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): TopicRuleKafkaArgs = TopicRuleKafkaArgs(
        clientProperties = clientProperties ?: throw PulumiNullFieldException("clientProperties"),
        destinationArn = destinationArn ?: throw PulumiNullFieldException("destinationArn"),
        headers = headers,
        key = key,
        partition = partition,
        topic = topic ?: throw PulumiNullFieldException("topic"),
    )
}
