@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleKinesisArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partitionKey The partition key.
 * @property roleArn The ARN of the IAM role that grants access to the Amazon Kinesis stream.
 * @property streamName The name of the Amazon Kinesis stream.
 */
public data class TopicRuleKinesisArgs(
    public val partitionKey: Output<String>? = null,
    public val roleArn: Output<String>,
    public val streamName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleKinesisArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleKinesisArgs =
        com.pulumi.aws.iot.inputs.TopicRuleKinesisArgs.builder()
            .partitionKey(partitionKey?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .streamName(streamName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleKinesisArgs].
 */
@PulumiTagMarker
public class TopicRuleKinesisArgsBuilder internal constructor() {
    private var partitionKey: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var streamName: Output<String>? = null

    /**
     * @param value The partition key.
     */
    @JvmName("bauveuahyfvknxkq")
    public suspend fun partitionKey(`value`: Output<String>) {
        this.partitionKey = value
    }

    /**
     * @param value The ARN of the IAM role that grants access to the Amazon Kinesis stream.
     */
    @JvmName("nebcxskiwblmgryl")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the Amazon Kinesis stream.
     */
    @JvmName("wayimwrngelmlwmi")
    public suspend fun streamName(`value`: Output<String>) {
        this.streamName = value
    }

    /**
     * @param value The partition key.
     */
    @JvmName("xteboelejksqsvad")
    public suspend fun partitionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access to the Amazon Kinesis stream.
     */
    @JvmName("jvritvaunxuhjras")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the Amazon Kinesis stream.
     */
    @JvmName("wifsxahstghipptr")
    public suspend fun streamName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamName = mapped
    }

    internal fun build(): TopicRuleKinesisArgs = TopicRuleKinesisArgs(
        partitionKey = partitionKey,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        streamName = streamName ?: throw PulumiNullFieldException("streamName"),
    )
}
