@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleLambdaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property functionArn The ARN of the Lambda function.
 */
public data class TopicRuleLambdaArgs(
    public val functionArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleLambdaArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleLambdaArgs =
        com.pulumi.aws.iot.inputs.TopicRuleLambdaArgs.builder()
            .functionArn(functionArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleLambdaArgs].
 */
@PulumiTagMarker
public class TopicRuleLambdaArgsBuilder internal constructor() {
    private var functionArn: Output<String>? = null

    /**
     * @param value The ARN of the Lambda function.
     */
    @JvmName("cjahdfuwiqdokbni")
    public suspend fun functionArn(`value`: Output<String>) {
        this.functionArn = value
    }

    /**
     * @param value The ARN of the Lambda function.
     */
    @JvmName("syxwkxfywbokdbda")
    public suspend fun functionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionArn = mapped
    }

    internal fun build(): TopicRuleLambdaArgs = TopicRuleLambdaArgs(
        functionArn = functionArn ?: throw PulumiNullFieldException("functionArn"),
    )
}
