@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The Amazon S3 bucket name.
 * @property cannedAcl The Amazon S3 canned ACL that controls access to the object identified by the object key. [Valid values](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
 * @property key The name of the HTTP header.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 */
public data class TopicRuleS3Args(
    public val bucketName: Output<String>,
    public val cannedAcl: Output<String>? = null,
    public val key: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleS3Args> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleS3Args =
        com.pulumi.aws.iot.inputs.TopicRuleS3Args.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .cannedAcl(cannedAcl?.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleS3Args].
 */
@PulumiTagMarker
public class TopicRuleS3ArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var cannedAcl: Output<String>? = null

    private var key: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The Amazon S3 bucket name.
     */
    @JvmName("rqnagaxnxuolouxw")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The Amazon S3 canned ACL that controls access to the object identified by the object key. [Valid values](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
     */
    @JvmName("bjqnckynbwenxpdd")
    public suspend fun cannedAcl(`value`: Output<String>) {
        this.cannedAcl = value
    }

    /**
     * @param value The name of the HTTP header.
     */
    @JvmName("hjcjkwqxdhwcikhb")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("sttshgbfmokqihhy")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The Amazon S3 bucket name.
     */
    @JvmName("jklsrihhqlqpycus")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The Amazon S3 canned ACL that controls access to the object identified by the object key. [Valid values](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
     */
    @JvmName("rwbwmixworecgfdo")
    public suspend fun cannedAcl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cannedAcl = mapped
    }

    /**
     * @param value The name of the HTTP header.
     */
    @JvmName("pcfkhcdpsyjvpdob")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("bysldojitnjwqyqs")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleS3Args = TopicRuleS3Args(
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        cannedAcl = cannedAcl,
        key = key ?: throw PulumiNullFieldException("key"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
