@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleTimestreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of an Amazon Timestream database.
 * @property dimensions Configuration blocks with metadata attributes of the time series that are written in each measure record. Nested arguments below.
 * @property roleArn The ARN of the role that grants permission to write to the Amazon Timestream database table.
 * @property tableName The name of the database table into which to write the measure records.
 * @property timestamp Configuration block specifying an application-defined value to replace the default value assigned to the Timestream record's timestamp in the time column. Nested arguments below.
 */
public data class TopicRuleTimestreamArgs(
    public val databaseName: Output<String>,
    public val dimensions: Output<List<TopicRuleTimestreamDimensionArgs>>,
    public val roleArn: Output<String>,
    public val tableName: Output<String>,
    public val timestamp: Output<TopicRuleTimestreamTimestampArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleTimestreamArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleTimestreamArgs =
        com.pulumi.aws.iot.inputs.TopicRuleTimestreamArgs.builder()
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .dimensions(
                dimensions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 }))
            .timestamp(timestamp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TopicRuleTimestreamArgs].
 */
@PulumiTagMarker
public class TopicRuleTimestreamArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var dimensions: Output<List<TopicRuleTimestreamDimensionArgs>>? = null

    private var roleArn: Output<String>? = null

    private var tableName: Output<String>? = null

    private var timestamp: Output<TopicRuleTimestreamTimestampArgs>? = null

    /**
     * @param value The name of an Amazon Timestream database.
     */
    @JvmName("trsikmxenuomuvel")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Configuration blocks with metadata attributes of the time series that are written in each measure record. Nested arguments below.
     */
    @JvmName("bcmmvhlxkjnqkjka")
    public suspend fun dimensions(`value`: Output<List<TopicRuleTimestreamDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("qknercjdpcoijous")
    public suspend fun dimensions(vararg values: Output<TopicRuleTimestreamDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks with metadata attributes of the time series that are written in each measure record. Nested arguments below.
     */
    @JvmName("mcafnmoebhoyhutu")
    public suspend fun dimensions(values: List<Output<TopicRuleTimestreamDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value The ARN of the role that grants permission to write to the Amazon Timestream database table.
     */
    @JvmName("uoulpexrksvdvubr")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the database table into which to write the measure records.
     */
    @JvmName("rgwgvidrrqaxbwnq")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value Configuration block specifying an application-defined value to replace the default value assigned to the Timestream record's timestamp in the time column. Nested arguments below.
     */
    @JvmName("evoyfpnmruymkyhk")
    public suspend fun timestamp(`value`: Output<TopicRuleTimestreamTimestampArgs>) {
        this.timestamp = value
    }

    /**
     * @param value The name of an Amazon Timestream database.
     */
    @JvmName("ytiqvrqvfpfmnvwv")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Configuration blocks with metadata attributes of the time series that are written in each measure record. Nested arguments below.
     */
    @JvmName("iecvcyhyljaypmoo")
    public suspend fun dimensions(`value`: List<TopicRuleTimestreamDimensionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Configuration blocks with metadata attributes of the time series that are written in each measure record. Nested arguments below.
     */
    @JvmName("fcpcbrjxxmgwqllh")
    public suspend
    fun dimensions(argument: List<suspend TopicRuleTimestreamDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleTimestreamDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Configuration blocks with metadata attributes of the time series that are written in each measure record. Nested arguments below.
     */
    @JvmName("wwothwpviooftcuk")
    public suspend fun dimensions(
        vararg
        argument: suspend TopicRuleTimestreamDimensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopicRuleTimestreamDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Configuration blocks with metadata attributes of the time series that are written in each measure record. Nested arguments below.
     */
    @JvmName("ablmsrtrguunggjx")
    public suspend
    fun dimensions(argument: suspend TopicRuleTimestreamDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TopicRuleTimestreamDimensionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values Configuration blocks with metadata attributes of the time series that are written in each measure record. Nested arguments below.
     */
    @JvmName("mqoryuhfetyhsank")
    public suspend fun dimensions(vararg values: TopicRuleTimestreamDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The ARN of the role that grants permission to write to the Amazon Timestream database table.
     */
    @JvmName("ohuaawvuulmvjcfi")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the database table into which to write the measure records.
     */
    @JvmName("tfolpiksgyusnymm")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value Configuration block specifying an application-defined value to replace the default value assigned to the Timestream record's timestamp in the time column. Nested arguments below.
     */
    @JvmName("abqsrhdnwkbwgoyk")
    public suspend fun timestamp(`value`: TopicRuleTimestreamTimestampArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestamp = mapped
    }

    /**
     * @param argument Configuration block specifying an application-defined value to replace the default value assigned to the Timestream record's timestamp in the time column. Nested arguments below.
     */
    @JvmName("ykqmofybitxmhuuo")
    public suspend
    fun timestamp(argument: suspend TopicRuleTimestreamTimestampArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleTimestreamTimestampArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timestamp = mapped
    }

    internal fun build(): TopicRuleTimestreamArgs = TopicRuleTimestreamArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        dimensions = dimensions ?: throw PulumiNullFieldException("dimensions"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        timestamp = timestamp,
    )
}
