@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleTimestreamTimestampArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unit The precision of the timestamp value that results from the expression described in value. Valid values: `SECONDS`, `MILLISECONDS`, `MICROSECONDS`, `NANOSECONDS`.
 * @property value The value of the HTTP header.
 */
public data class TopicRuleTimestreamTimestampArgs(
    public val unit: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleTimestreamTimestampArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleTimestreamTimestampArgs =
        com.pulumi.aws.iot.inputs.TopicRuleTimestreamTimestampArgs.builder()
            .unit(unit.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleTimestreamTimestampArgs].
 */
@PulumiTagMarker
public class TopicRuleTimestreamTimestampArgsBuilder internal constructor() {
    private var unit: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The precision of the timestamp value that results from the expression described in value. Valid values: `SECONDS`, `MILLISECONDS`, `MICROSECONDS`, `NANOSECONDS`.
     */
    @JvmName("rlebftuuslxkxbvk")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value The value of the HTTP header.
     */
    @JvmName("kwoatwephqehmkad")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The precision of the timestamp value that results from the expression described in value. Valid values: `SECONDS`, `MILLISECONDS`, `MICROSECONDS`, `NANOSECONDS`.
     */
    @JvmName("axyqootkcuijtnug")
    public suspend fun unit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    /**
     * @param value The value of the HTTP header.
     */
    @JvmName("snnjibdasjvlmtan")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TopicRuleTimestreamTimestampArgs = TopicRuleTimestreamTimestampArgs(
        unit = unit ?: throw PulumiNullFieldException("unit"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
