@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property notAfter The certificate is not valid after this date.
 * @property notBefore The certificate is not valid before this date.
 */
public data class CaCertificateValidity(
    public val notAfter: String? = null,
    public val notBefore: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.CaCertificateValidity):
            CaCertificateValidity = CaCertificateValidity(
            notAfter = javaType.notAfter().map({ args0 -> args0 }).orElse(null),
            notBefore = javaType.notBefore().map({ args0 -> args0 }).orElse(null),
        )
    }
}
