@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allowAuthorizerOverride A Boolean that specifies whether the domain configuration's authorization service can be overridden.
 * @property defaultAuthorizerName The name of the authorization service for a domain configuration.
 */
public data class DomainConfigurationAuthorizerConfig(
    public val allowAuthorizerOverride: Boolean? = null,
    public val defaultAuthorizerName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.DomainConfigurationAuthorizerConfig):
            DomainConfigurationAuthorizerConfig = DomainConfigurationAuthorizerConfig(
            allowAuthorizerOverride = javaType.allowAuthorizerOverride().map({ args0 -> args0 }).orElse(null),
            defaultAuthorizerName = javaType.defaultAuthorizerName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
