@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEndpoint.
 * @property endpointAddress Endpoint based on `endpoint_type`:
 * * No `endpoint_type`: Either `iot:Data` or `iot:Data-ATS` [depending on region](https://aws.amazon.com/blogs/iot/aws-iot-core-ats-endpoints/)
 * * `iot:CredentialsProvider`: `IDENTIFIER.credentials.iot.REGION.amazonaws.com`
 * * `iot:Data`: `IDENTIFIER.iot.REGION.amazonaws.com`
 * * `iot:Data-ATS`: `IDENTIFIER-ats.iot.REGION.amazonaws.com`
 * * `iot:Jobs`: `IDENTIFIER.jobs.iot.REGION.amazonaws.com`
 * @property endpointType
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetEndpointResult(
    public val endpointAddress: String,
    public val endpointType: String? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.GetEndpointResult): GetEndpointResult =
            GetEndpointResult(
                endpointAddress = javaType.endpointAddress(),
                endpointType = javaType.endpointType().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
            )
    }
}
