@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customFields A list of thing group fields to index. This list cannot contain any managed fields. See below.
 * @property managedFields Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
 * @property thingGroupIndexingMode Thing group indexing mode. Valid values: `OFF`, `ON`.
 */
public data class IndexingConfigurationThingGroupIndexingConfiguration(
    public val customFields: List<IndexingConfigurationThingGroupIndexingConfigurationCustomField>? =
        null,
    public val managedFields: List<IndexingConfigurationThingGroupIndexingConfigurationManagedField>? =
        null,
    public val thingGroupIndexingMode: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.iot.outputs.IndexingConfigurationThingGroupIndexingConfiguration):
            IndexingConfigurationThingGroupIndexingConfiguration =
            IndexingConfigurationThingGroupIndexingConfiguration(
                customFields = javaType.customFields().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingGroupIndexingConfigurationCustomField.Companion.toKotlin(args0)
                    })
                }),
                managedFields = javaType.managedFields().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingGroupIndexingConfigurationManagedField.Companion.toKotlin(args0)
                    })
                }),
                thingGroupIndexingMode = javaType.thingGroupIndexingMode(),
            )
    }
}
