@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property creationDate
 * @property parentGroupName The name of the parent Thing Group.
 * @property rootToParentGroups
 */
public data class ThingGroupMetadata(
    public val creationDate: String? = null,
    public val parentGroupName: String? = null,
    public val rootToParentGroups: List<ThingGroupMetadataRootToParentGroup>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.ThingGroupMetadata): ThingGroupMetadata =
            ThingGroupMetadata(
                creationDate = javaType.creationDate().map({ args0 -> args0 }).orElse(null),
                parentGroupName = javaType.parentGroupName().map({ args0 -> args0 }).orElse(null),
                rootToParentGroups = javaType.rootToParentGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.iot.kotlin.outputs.ThingGroupMetadataRootToParentGroup.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
