@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attributePayload The Thing Group attributes. Defined below.
 * @property description A description of the Thing Group.
 */
public data class ThingGroupProperties(
    public val attributePayload: ThingGroupPropertiesAttributePayload? = null,
    public val description: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.ThingGroupProperties):
            ThingGroupProperties = ThingGroupProperties(
            attributePayload = javaType.attributePayload().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iot.kotlin.outputs.ThingGroupPropertiesAttributePayload.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
        )
    }
}
