@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property logGroupName The CloudWatch log group name.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 */
public data class TopicRuleCloudwatchLog(
    public val logGroupName: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleCloudwatchLog):
            TopicRuleCloudwatchLog = TopicRuleCloudwatchLog(
            logGroupName = javaType.logGroupName(),
            roleArn = javaType.roleArn(),
        )
    }
}
